% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connectivity.R
\name{connectivity}
\alias{connectivity}
\title{Calculate and plot maps}
\usage{
connectivity(
  host,
  indices,
  global = FALSE,
  east = NULL,
  west = NULL,
  geoscale = NULL,
  res = reso(),
  pmean = TRUE,
  pvar = TRUE,
  pdiff = TRUE,
  outdir = tempdir()
)
}
\arguments{
\item{host}{SpatRaster. Host density map aka \code{SpatRaster} object}

\item{indices}{SpatRaster. Collection of risk indices.}

\item{global}{Logical. \code{TRUE} if global analysis is desired, \code{FALSE} otherwise.
\code{east} and \code{west} are required when \code{TRUE}.}

\item{east}{SpatRaster. Collection of risk indices on eastern extent.}

\item{west}{SpatRaster. Collection of risk indices on western extent.
When \code{TRUE}, \code{geoscale} is ignored. Default is \code{TRUE}.}

\item{geoscale}{Vector. geographical scale. Default is \code{NULL}.}

\item{res}{Numeric. Map resolution. This value is used in aggregation and dis-aggregation operation.
Default is \code{\link[=reso]{reso()}}.}

\item{pmean}{Logical. \code{TRUE} if map of mean should be plotted, \code{FALSE} otherwise.}

\item{pvar}{Logical. \code{TRUE} if variance map should be plotted, \code{FALSE} otherwise.}

\item{pdiff}{Logical. \code{TRUE} if difference map should be plotted, \code{FALSE} otherwise.}

\item{outdir}{Character. Output directory for saving raster in TIFF format.
Default is \code{\link[=tempdir]{tempdir()}}.}
}
\value{
Gmap. See details.
}
\description{
Calculate mean, variance and difference. The result is produced in form of maps plotted with predefined settings.
Currently, the settings for plot cannot be customized.
Default value is \code{TRUE} for all logical arguments
}
\details{
\code{indexes} are actually risk indices i.e. lis of \code{spatRaster} objects
resulting from operations on crop's raster and
parameters provided in either \code{parameters.yaml} or \code{\link[=sean]{sean()}}.

It will save all the opted plots using - \code{pmean}, \code{pvar} and \code{pdiff}.
File will be saved in provided value of \code{outdir} or  \code{\link[=tempdir]{tempdir()}}.If \code{\link[=interactive]{interactive()}} is \code{TRUE},
then plots can be seen in active plot window. E.g. Rstudio. The maps are plotted using \code{SpatRaster} object.
These objects are available as a return value of this function.
}
\references{
Yanru Xing, John F Hernandez Nopsa, Kelsey F Andersen, Jorge L Andrade-Piedra, Fenton D Beed,
Guy Blomme, Mónica Carvajal-Yepes, Danny L Coyne, Wilmer J Cuellar, Gregory A Forbes,
Jan F Kreuze, Jürgen Kroschel, P Lava Kumar, James P Legg, Monica Parker, Elmar Schulte-Geldermann,
Kalpana Sharma, Karen A Garrett,
\emph{Global Cropland .connectivity: A Risk Factor for Invasion and Saturation by Emerging Pathogens and Pests},
BioScience, Volume 70, Issue 9, September 2020, Pages 744–758,
\doi{10.1093/biosci/biaa067}

Hijmans R (2023). \emph{terra: Spatial Data Analysis}.
R package version 1.7-46, \url{https://CRAN.R-project.org/package=terra}
}
\seealso{
\code{\link[=hci_mean]{hci_mean()}}, \code{\link[=hci_variance]{hci_variance()}}, \code{\link[=hci_diff]{hci_diff()}}
}
