% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uscb_acs_5ye_get_geo.R
\name{download_geodatabases}
\alias{download_geodatabases}
\alias{download_geodatabases.uscb_acs_5ye}
\title{Download geodatabases}
\usage{
download_geodatabases(ua, geodatabase, years, folder = NULL)

\method{download_geodatabases}{uscb_acs_5ye}(ua, geodatabase, years, folder = NULL)
}
\arguments{
\item{ua}{A \code{uscb_acs_5ye} object.}

\item{geodatabase}{A string.}

\item{years}{A vector of integers.}

\item{folder}{A string.}
}
\value{
A vector of integers.
}
\description{
For the name of a geodatabase and the given years, downloads from the web the
corresponding geodatabase data files. Returns a vector with the years for
which data is now available on the folder.
}
\details{
If the folder is not indicated, it is considered that of the class.
}
\examples{

folder <- "../geodimension/data/us/"
ua <- uscb_acs_5ye(folder = folder)
sa <- ua |> get_statistical_areas()

# sa[6]
# [1] "New England City and Town Area Division"
\donttest{
y <- ua |> get_available_years_in_the_web(geodatabase = sa[6])
\dontrun{
y_res <- ua |> download_geodatabases(geodatabase = sa[6], years = y)
}
}
}
\seealso{
Other data collection functions: 
\code{\link{get_available_years_downloaded}()},
\code{\link{get_available_years_in_the_web}()},
\code{\link{get_legal_and_administrative_areas}()},
\code{\link{get_statistical_areas}()},
\code{\link{uscb_acs_5ye}()}
}
\concept{data collection functions}
