% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getA.R
\name{getA}
\alias{getA}
\title{Compute the matrix A}
\usage{
getA(alpha, gamma, delta, lambda, kappa)
}
\arguments{
\item{alpha}{protection rate}

\item{gamma}{inverse of the average latent time}

\item{delta}{rate of people entering in quarantine}

\item{lambda}{cure rate}

\item{kappa}{mortality rate}
}
\value{
The matrix A that is found in: dY/dt = A*Y + F
}
\description{
This function computes the matrix A that is found in: dY/dt = A*Y + F
}
\references{
Peng, L., Yang, W., Zhang, D., Zhuge, C., Hong, L. 2020. “Epidemic analysis of COVID-19 in China by dynamical modeling”, arXiv preprint arXiv:2002.06563.

\url{https://www.mathworks.com/matlabcentral/fileexchange/74545-generalized-seir-epidemic-model-fitting-and-computation}
}
\seealso{
\code{\link{SEIQRDP}} \code{\link{fit_SEIQRDP}}
}
\author{
Selcuk Korkmaz, \email{selcukorkmaz@gmail.com}
}
