% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ogr2ogr.R
\name{ogr2ogr}
\alias{ogr2ogr}
\title{Interface to GDAL's ogr2ogr utility}
\usage{
ogr2ogr(
  src_datasource_name,
  dst_datasource_name,
  ...,
  layer,
  f,
  append,
  overwrite,
  update,
  select,
  progress,
  sql,
  dialect,
  where,
  skipfailures,
  spat,
  spat_srs,
  geomfield,
  dsco,
  lco,
  nln,
  nlt,
  dim,
  a_srs,
  t_srs,
  s_srs,
  ct,
  preserve_fid,
  fid,
  limit,
  oo,
  doo,
  gt,
  ds_transaction,
  clipsrc,
  clipsrcsql,
  clipsrclayer,
  clipsrcwhere,
  clipdst,
  clipdstsql,
  clipdstlayer,
  clipdstwhere,
  wrapdateline,
  datelineoffset,
  simplify,
  segmentize,
  makevalid,
  fieldTypeToString,
  mapFieldType,
  unsetFieldWidth,
  splitlistfields,
  maxsubfields,
  explodecollections,
  zfield,
  gcp,
  order,
  tps,
  fieldmap,
  addfields,
  relaxedFieldNameMatch,
  forceNullable,
  unsetDefault,
  unsetFid,
  emptyStrAsNull,
  nomd,
  mo,
  noNativeData,
  dryrun = FALSE
)
}
\arguments{
\item{src_datasource_name}{Character. Path to a GDAL-supported
readable datasource.}

\item{dst_datasource_name}{Character. Path to a GDAL-supported
output file.}

\item{...}{Here, a placeholder argument that forces users to
supply exact names of all subsequent formal arguments.}

\item{layer, f, append, overwrite, update, select, progress, sql, dialect}{See the GDAL project's
\href{https://gdal.org/programs/ogr2ogr.html}{ogr2ogr
documentation} for details.}

\item{where, skipfailures, spat, spat_srs, geomfield, dsco, lco, nln, nlt}{See \href{https://gdal.org/programs/ogr2ogr.html}{ogr2ogr
documentation}.}

\item{dim, a_srs, t_srs, s_srs, ct, preserve_fid, fid, limit, oo, doo, gt}{See the See
\href{https://gdal.org/programs/ogr2ogr.html}{ogr2ogr
documentation}.}

\item{ds_transaction, clipsrc, clipsrcsql, clipsrclayer, clipsrcwhere}{See \href{https://gdal.org/programs/ogr2ogr.html}{ogr2ogr
documentation}.}

\item{clipdst, clipdstsql, clipdstlayer, clipdstwhere, wrapdateline}{See \href{https://gdal.org/programs/ogr2ogr.html}{ogr2ogr
documentation}.}

\item{datelineoffset, simplify, segmentize, makevalid}{See
See \href{https://gdal.org/programs/ogr2ogr.html}{ogr2ogr
documentation}.}

\item{fieldTypeToString, mapFieldType, unsetFieldWidth}{See \href{https://gdal.org/programs/ogr2ogr.html}{ogr2ogr
documentation}.}

\item{splitlistfields, maxsubfields, explodecollections, zfield, gcp}{See \href{https://gdal.org/programs/ogr2ogr.html}{ogr2ogr
documentation}.}

\item{order, tps, fieldmap, addfields, relaxedFieldNameMatch}{See \href{https://gdal.org/programs/ogr2ogr.html}{ogr2ogr
documentation}.}

\item{forceNullable, unsetDefault, unsetFid, emptyStrAsNull, nomd}{See
\href{https://gdal.org/programs/ogr2ogr.html}{ogr2ogr
documentation}.}

\item{mo, noNativeData}{See
\href{https://gdal.org/programs/ogr2ogr.html}{ogr2ogr
documentation}.}

\item{dryrun}{Logical (default \code{FALSE}). If \code{TRUE},
instead of executing the requested call to GDAL, the function
will print the command-line call that would produce the
equivalent output.}
}
\value{
None. Called instead for its side effect.
}
\description{
This function provides an interface mirroring that of the GDAL
command-line app \code{ogr2ogr}.  For a description of the
utility and the arguments that it takes, see the documentation at
\url{https://gdal.org/programs/ogr2ogr.html}.
}
\examples{
\donttest{
## Prepare file paths
td <- tempdir()
lux <- system.file("external/lux.shp", package = "raster")
lux_merc <- file.path(td, "mercator.shp")
lux_lcc <- file.path(td, "lcc.shp")

## Reproject to 'WGS 84/World Mercator'
## https://en.wikipedia.org/wiki/Mercator_projection
ogr2ogr(lux, lux_merc, t_srs = "EPSG:3395", overwrite = TRUE)
## Reproject to a Canadian 'Lambert conformal conic projection'
## https://en.wikipedia.org/wiki/Lambert_conformal_conic_projection
ogr2ogr(lux, lux_lcc, t_srs = "EPSG:3347", overwrite = TRUE)

if(require(raster)) {
    op <- par(mfcol = c(1,2))
    plot(shapefile(lux_merc), main = "WGS 84",
         border = "darkgrey", col = gray.colors(12))
    plot(shapefile(lux_lcc), main = "LCC",
         border = "darkgrey", col = gray.colors(12))
    par(op)
}
}
}
\author{
Joshua O'Brien
}
