% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atlas_occurrences.R
\name{atlas_occurrences}
\alias{atlas_occurrences}
\title{Return occurrence records}
\usage{
atlas_occurrences(
  request = NULL,
  identify = NULL,
  filter = NULL,
  geolocate = NULL,
  data_profile = NULL,
  select = NULL,
  mint_doi = FALSE,
  doi = NULL,
  refresh_cache = FALSE
)
}
\arguments{
\item{request}{optional \code{data_request} object: generated by a call to
\code{\link[=galah_call]{galah_call()}}.}

\item{identify}{\code{data.frame}: generated by a call to
\code{\link[=galah_identify]{galah_identify()}}.}

\item{filter}{\code{data.frame}: generated by a call to
\code{\link[=galah_filter]{galah_filter()}}}

\item{geolocate}{\code{string}: generated by a call to
\code{\link[=galah_geolocate]{galah_geolocate()}}}

\item{data_profile}{\code{string}: generated by a call to
\code{\link[=galah_apply_profile]{galah_apply_profile()}}}

\item{select}{\code{data.frame}: generated by a call to
\code{\link[=galah_select]{galah_select()}}}

\item{mint_doi}{\code{logical}: by default no DOI will be generated. Set to
\code{TRUE} if you intend to use the data in a publication or similar}

\item{doi}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{collect_occurrences} instead.

\code{string}: this argument enables retrieval of occurrence records previously
downloaded from the ALA, using the DOI generated by the data.}

\item{refresh_cache}{\code{logical}: if set to \code{TRUE} and
\code{galah_config(caching = TRUE)} then files cached from a previous query will
be replaced by the current query}
}
\value{
An object of class \code{tbl_df} and \code{data.frame} (aka a tibble) of
occurrences, containing columns as specified by \code{\link[=galah_select]{galah_select()}}.
The \code{data.frame} object has the following attributes:
\itemize{
\item a listing of the user-supplied arguments of the \code{data_request}
(i.e., identify, filter, geolocate, select)
\item a \code{doi} of the data download
\item the \code{search_url} of the query to ALA API
}
}
\description{
The most common form of data stored by living atlases are observations of
individual life forms, known as 'occurrences'. This function allows the
user to search for occurrence records that match their specific criteria,
and return them as a \code{data.frame} for analysis. Optionally,
the user can also request a DOI for a given download to facilitate citation
and re-use of specific data resources.
}
\details{
Note that unless care is taken, some queries can be particularly large.
While most cases this will simply take a long time to process, if the number
of requested records is >50 million the call will not return any data. Users
can test whether this threshold will be reached by first calling
\code{\link[=atlas_counts]{atlas_counts()}} using the same arguments that they intend to pass to
\code{atlas_occurrences}(). It may also be beneficial when requesting a large
number of records to show a progress bar by setting \code{verbose = TRUE} in
\code{\link[=galah_config]{galah_config()}}.
}
\examples{
\dontrun{
# Download occurrence records for a specific taxon
galah_config(email = "your_email_here")
galah_call() |>
  galah_identify("Reptilia") |>
  atlas_occurrences()

# Download occurrence records in a year range
galah_call() |>
  galah_identify("Litoria") |>
  galah_filter(year >= 2010 & year <= 2020) |>
  atlas_occurrences()

# Download occurrences records in a WKT-specified area
polygon <- "POLYGON((146.24960 -34.05930,
                     146.37045 -34.05930,
                     146.37045 -34.152549,
                     146.24960 -34.15254,
                     146.24960 -34.05930))"
galah_call() |> 
  galah_identify("Reptilia") |>
  galah_filter(year >= 2010, year <= 2020) |>
  galah_geolocate(polygon) |>
  atlas_occurrences()
}

}
