% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{binaryPoints}
\alias{binaryPoints}
\title{Binary (0-1) points in the feasible region (Ax<=b).}
\usage{
binaryPoints(A, b)
}
\arguments{
\item{A}{Constraint matrix.}

\item{b}{Right hand side.}
}
\value{
A data frame with all binary points inside the feasible region.
}
\description{
Binary (0-1) points in the feasible region (Ax<=b).
}
\note{
Do a simple enumeration of all binary points. Will not work if \code{ncol(A)} large.
}
\examples{
A <- matrix( c(3,-2, 1, 2, 4,-2,-3, 2, 1), nc = 3, byrow = TRUE)
b <- c(10, 12, 3)
binaryPoints(A, b)

A <- matrix(c(9, 10, 2, 4, -3, 2), ncol = 2, byrow = TRUE)
b <- c(90, 27, 3)
binaryPoints(A, b)
}
\author{
Lars Relund \email{lars@relund.dk}.
}
