# WARNING - Generated by {fusen} from dev/flat_init_share_on_github.Rmd: do not edit by hand # nolint: line_length_linter.

test_that("init_share_on_github works", {
  skip_if_not(interactive())

  if (Sys.getenv("FUSEN_TEST_PUBLISH", unset = "FALSE") == "TRUE") {
    # Only create the project if specifically asked by maintainers
    path_project <- file.path(tempdir(), paste0("fusen.github.", packageVersion("fusen")))
    # path_project <- tempfile("fusen.github.proj")
    the_devs <- create_fusen(path = path_project, template = "teaching", with_git = TRUE, open = FALSE)
    the_flat <- the_devs[grep("flat", the_devs)]
    # Follow the "dev/0-dev_history.Rmd"
    usethis::with_project(path_project, {
      fill_description(
        pkg = path_project,
        fields = list(
          Title = "Share Your Project Following Good Development Practices From a Rmarkdown File",
          Description = "Use Rmarkdown First method. Strengthen your work with documentation and tests. Everything can be set from a Rmarkdown file in your project.",
          `Authors@R` = c(
            person("John", "Doe", email = "john@email.me", role = c("aut", "cre"), comment = c(ORCID = "0000-0000-0000-0000"))
          )
        )
      )
      # Define License with use_*_license()
      usethis::use_mit_license("John Doe")

      # Inflate ?
      inflate(flat_file = the_flat, vignette_name = "Get started", open_vignette = FALSE)
    })

    usethis::with_project(path_project, {
      # Share on GitHub
      website_url <- init_share_on_github()
    }) # End of with_project

    do_it <- readline("Does pkgdown website exists after following instructions? (y/n)") == "y"
    expect_true(do_it)

    # Clean state
    unlink(path_project, recursive = TRUE)
  }
})
