% Generated by roxygen2 (4.0.2): do not edit by hand
\name{hclustvfreq}
\alias{.hclustvfreq}
\alias{hclustvfreq}
\title{Fast hierarchical, agglomerative clustering of frequency data}
\usage{
hclustvfreq(data, freq = NULL, method = "single", metric = "euclidean",
  p = NULL)

.hclustvfreq(tfq, method = "single", metric = "euclidean", p = NULL)
}
\arguments{
\item{data}{any object that can be coerced into a double matrix}

\item{freq}{a one-sided, single term formula specifying frequency weights}

\item{method}{the agglomeration method to be used. This must be (an unambiguous abbreviation of) one of "\code{single}", "\code{ward}", "\code{centroid}" or "\code{median}".}

\item{metric}{the distance measure to be used. This must be one of \code{"euclidean"}, \code{"maximum"}, \code{"manhattan"}, \code{"canberra"}, \code{"binary"} or \code{"minkowski"}}

\item{p}{parameter for the Minkowski metric.}

\item{tfq}{a frequency table}
}
\description{
This function implements a version of the hierarchical, agglomerative clustering  \code{\link[fastcluster]{hclust.vector}} focused on table of frequencies.
}
\details{
Any variables in the formula are removed from the data set.

This function is a wrapper of \code{\link[fastcluster]{hclust.vector}} to be used with tables of frequencies. It use the frequency weights as parameter \code{members}.
}
\examples{
library(dplyr)
library(fastcluster)

data <- iris[,1:3,drop=FALSE]
hc <- hclustvfreq(data, method="centroid",metric="euclidean")
cutree(hc,3) ## Different length than data

tfq <- tablefreq(iris[,1:3])
hc <- .hclustvfreq(tfq, method="centroid",metric="euclidean")
tfq$group <- cutree(hc,3)
}
\seealso{
\code{\link[fastcluster]{hclust.vector}}, \code{link{tablefreq}}
}

