% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GloDenReg.R
\name{GloDenReg}
\alias{GloDenReg}
\title{Global density regression.}
\usage{
GloDenReg(
  xin = NULL,
  yin = NULL,
  hin = NULL,
  qin = NULL,
  xout = NULL,
  optns = list()
)
}
\arguments{
\item{xin}{An n by p matrix or a vector of length n (if p=1) with input measurements of the predictors.}

\item{yin}{A matrix or list holding the sample of observations of the response. If \code{yin} is a matrix, each row holds the observations of the response corresponding to a row in \code{xin}.}

\item{hin}{A list holding the histograms of the response corresponding to each row in \code{xin}.}

\item{qin}{A matrix or list holding the quantile functions of the response. If \code{qin} is a matrix, each row holds the quantile function of the response taking values on \code{optns$qSup} corresponding to a row in \code{xin}.
Note that only one of the three \code{yin}, \code{hin}, and \code{qin} needs to be input.
If more than one of them are specified, \code{yin} overwrites \code{hin}, and \code{hin} overwrites \code{qin}.}

\item{xout}{A k by p matrix or a vector of length k (if p=1) with output measurements of the predictors. Default is \code{xin}.}

\item{optns}{A list of control parameters specified by \code{list(name=value)}.}
}
\value{
A list containing the following components:
\item{xout}{Input \code{xout}.}
\item{dout}{A matrix or list holding the output densities corresponding to \code{xout}. If \code{dout} is a matrix, each row gives a density and the domain grid is given in \code{dSup}. If \code{dout} is a list, each element is a list of two components, \code{x} and \code{y}, giving the domain grid and density function values, respectively.}
\item{dSup}{A numeric vector giving the domain grid of \code{dout} when it is a matrix.}
\item{qout}{A matrix holding the quantile functions of the output densities. Each row corresponds to a value in \code{xout}.}
\item{qSup}{A numeric vector giving the domain grid of \code{qout}.}
\item{xin}{Input \code{xin}.}
\item{din}{Densities corresponding to the input \code{yin}, \code{hin} or \code{qin}.}
\item{qin}{Quantile functions corresponding to the input \code{yin}, \code{hin} or \code{qin}.}
\item{Rsq}{A scalar giving the R squared value if \code{optns$Rsquared = TRUE}.}
\item{optns}{A list of control options used.}
}
\description{
Global Fréchet regression for densities with respect to \eqn{L^2}-Wasserstein distance.
}
\details{
Available control options are \code{qSup}, \code{nqSup}, 
\code{lower}, \code{upper}, \code{Rsquared}, \code{bwDen}, \code{ndSup}, \code{dSup}, 
\code{delta}, \code{kernelDen}, \code{infSupport}, and \code{denLowerThreshold}. 
\code{Rsquared} is explained as follows and see \code{\link{LocDenReg}} for the other options.
\describe{
\item{Rsquared}{A logical variable indicating whether R squared would be returned. Default is \code{FALSE}.}
}
}
\examples{
xin = seq(0,1,0.05)
yin = lapply(xin, function(x) {
  rnorm(100, rnorm(1,x,0.005), 0.05)
})
qSup = seq(0,1,0.02)
xout = seq(0,1,0.25)
res1 <- GloDenReg(xin=xin, yin=yin, xout=xout, optns = list(qSup = qSup))
plot(res1)
\donttest{
hin = lapply(yin, function(y) hist(y, breaks = 50, plot=FALSE))
res2 <- GloDenReg(xin=xin, hin=hin, xout=xout, optns = list(qSup = qSup))
plot(res2)
}
}
\references{
\cite{Petersen, A., & Müller, H.-G. (2019). "Fréchet regression for random objects with Euclidean predictors." The Annals of Statistics, 47(2), 691--719.}
}
