% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assessment_cooccurrences_summary.R
\name{assessment_cooccurrences_summary}
\alias{assessment_cooccurrences_summary}
\title{Generate a summary of co-occurrences in various assessment inventories}
\usage{
assessment_cooccurrences_summary(inventory_list)
}
\arguments{
\item{inventory_list}{A list of site inventories having the format of
\code{\link[=assessment_list_inventory]{assessment_list_inventory()}}.}
}
\value{
A data frame with 16 columns:
\itemize{
\item target_species (character)
\item target_species_c (numeric)
\item target_species_nativity (character)
\item target_species_n (numeric)
\item cospecies_n (numeric)
\item cospecies_native_n (numeric)
\item cospecies_mean_c (numeric)
\item cospecies_native_mean_c  (numeric)
\item cospecies_std_dev_c  (numeric)
\item cospecies_native_std_dev_c  (numeric)
\item percent_native  (numeric)
\item percent_nonnative (numeric)
\item percent_native_low_c (numeric)
\item percent_native_med_c  (numeric)
\item percent_native_high_c  (numeric)
\item discrepancy_c (numeric)
}
}
\description{
\code{assessment_coccurrences_summary()} accepts a list of species
inventories downloaded from
\href{https://universalfqa.org/}{universalfqa.org} and returns a summary of
the co-occurrences of each target species. Repeated co-occurrences across
multiple assessments are included in summary calculations, but self
co-occurrences are not.
}
\examples{
# assessment_cooccurrences_summary is best used in combination with
# download_assessment_list() and assessment_list_inventory().

\donttest{
maine <- download_assessment_list(database = 56)
maine_invs <- assessment_list_inventory(maine)
maine_cooccurrences_summary <- assessment_cooccurrences_summary(maine_invs)
}

}
