% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assessment_inventory.R
\name{assessment_inventory}
\alias{assessment_inventory}
\title{Obtain species details for a floristic quality assessment}
\usage{
assessment_inventory(data_set)
}
\arguments{
\item{data_set}{A data set downloaded from
\href{https://universalfqa.org/}{universalfqa.org} either manually or using
\code{\link[=download_assessment]{download_assessment()}}.}
}
\value{
A data frame with 9 columns:
\itemize{
   \item Scientific Name (character)
   \item Family (character)
   \item Acronym (character)
   \item Native? (character)
   \item C (numeric)
   \item W (numeric)
   \item Physiognomy (character)
   \item Duration (character)
   \item Common Name (character)
}
}
\description{
\code{assessment_inventory()} returns a data frame of all plant species
included in a floristic quality assessment obtained from
\href{https://universalfqa.org/}{universalfqa.org}.
}
\examples{
# While assessment_glance can be used with a .csv file downloaded
# manually from the universal FQA website, it is most typically used
# in combination with download_assessment().

edison <- download_assessment(25002)
assessment_inventory(edison)

}
