
<!-- README.md is generated from README.Rmd. Please edit that file -->

# fpp3 <img src="man/figures/logo.png" align="right" width = 150 />

<!-- badges: start -->

[![CRAN
status](https://www.r-pkg.org/badges/version/fpp3)](https://cran.r-project.org/package=fpp3)
[![R build
status](https://github.com/robjhyndman/fpp3/workflows/R-CMD-check/badge.svg)](https://github.com/robjhyndman/fpp3/actions)
[![Downloads](https://cranlogs.r-pkg.org/badges/fpp3)](https://cran.r-project.org/package=fpp3)
<!-- badges: end -->

## Overview

The fpp3 package contains data used in the book [*Forecasting:
Principles and Practice* (3rd edition)](https://OTexts.com/fpp3/) by Rob
J Hyndman and George Athanasopoulos. It also loads several packages
needed to do the analysis described in the book. These packages work
with the [tidyverse](https://www.tidyverse.org/) set of packages,
sharing common data representations and API design. Additional data sets
not used in the book are also included.

## Installation

You can install the **stable** version from
[CRAN](https://cran.r-project.org/package=fpp3).

``` r
install.packages('fpp3', dependencies = TRUE)
```

You can install the **development** version from
[Github](https://github.com/robjhyndman/fpp3)

``` r
# install.packages("remotes")
remotes::install_github("robjhyndman/fpp3")
```

## Usage

`library(fpp3)` will load the following packages:

- [tibble](https://tibble.tidyverse.org), for tibbles, a modern
  re-imagining of data frames.
- [dplyr](https://dplyr.tidyverse.org), for data manipulation.
- [tidyr](https://tidyr.tidyverse.org), to tidy data.
- [lubridate](https://lubridate.tidyverse.org), for dates/times.
- [ggplot2](https://ggplot2.tidyverse.org), for data visualisation.
- [tsibble](https://tsibble.tidyverts.org), for tsibbles, a time series
  version of a tibble.
- [tsibbledata](https://tsibbledata.tidyverts.org), various time series
  data sets in the form of tsibbles.
- [feasts](https://feasts.tidyverts.org), for features and statistics of
  time series.
- [fable](https://fable.tidyverts.org), for fitting models and producing
  forecasts.

You also get a condensed summary of conflicts with other packages you
have loaded:

``` r
library(fpp3)
#> Registered S3 method overwritten by 'tsibble':
#>   method               from 
#>   as_tibble.grouped_df dplyr
#> ── Attaching packages ─────────────────────────────────────── fpp3 1.0.0.9000 ──
#> ✔ tibble      3.2.1          ✔ tsibble     1.1.5     
#> ✔ dplyr       1.1.4          ✔ tsibbledata 0.4.1     
#> ✔ tidyr       1.3.1          ✔ feasts      0.3.2     
#> ✔ lubridate   1.9.3          ✔ fable       0.3.4.9000
#> ✔ ggplot2     3.5.1
#> ── Conflicts ───────────────────────────────────────────────── fpp3_conflicts ──
#> ✖ lubridate::date()    masks base::date()
#> ✖ dplyr::filter()      masks stats::filter()
#> ✖ tsibble::intersect() masks base::intersect()
#> ✖ tsibble::interval()  masks lubridate::interval()
#> ✖ dplyr::lag()         masks stats::lag()
#> ✖ tsibble::setdiff()   masks base::setdiff()
#> ✖ tsibble::union()     masks base::union()
```
