% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age_ranges.R
\name{age_ranges}
\alias{age_ranges}
\title{roxygen documentation}
\usage{
age_ranges(
  data,
  taxonomy = "genus",
  srt = "max_ma",
  end = "min_ma",
  mode = "max"
)
}
\arguments{
\item{data}{A three column dataframe comprising one or
more character columns of taxonomic names, a numeric
column of FADs and a numeric column of LADs}

\item{taxonomy}{A character vector corresponding to one or
more of the taxonomic name columns in data}

\item{srt}{A character vector of length one specifying the
FAD column in data}

\item{end}{A character vector of length one specifying the
LAD column in data}

\item{mode}{A character vector of length one specifying
the type of range table to return: one of max, min or
bounds. If not specified by the user, the function
behaviour will default to max}
}
\value{
A dataframe containing at least four columns:
taxon name, FAD, LAD and the taxonomic rank. If taxonomy
is of length one, taxonomic rank will be a vector of
identical names. If mode = "bounds", there will be two
pairs of age columns, denoting the upper and lower bounds
on the FAD and LAD for each taxon name
}
\description{
age_ranges
}
\details{
Function to derive a range table of taxon names from a
stratigraphic occurrence dataset. The default behaviour
is to return a total range table - the oldest FAD and
youngest LAD for each taxon (max), but the function can
also return the minimum range - youngest FAD and oldest
LAD (min), or the uncertainty bounds on each FAD and
LAD - the two oldest FADs and two youngest LADs (bounds).
The names for which ranges are derived are specified by
the taxononmy argument, but multiple elements can be
given here, allowing taxonomic range for higher clades
to also be returned.
}
\examples{
# load dataset
data("brachios")
# derive age ranges
rng <- age_ranges(brachios)
}
