% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{outer}
\alias{outer}
\alias{outer1}
\alias{outer2}
\alias{outer1_matvec}
\alias{outer2_matvec}
\title{Outer Matrix}
\usage{
outer1(X, f)

outer2(X, Y, f)

outer1_matvec(X, f, a)

outer2_matvec(X, Y, f, a)
}
\arguments{
\item{X}{A numerical matrix.}

\item{f}{Function \eqn{f(x, y)} that operates on a pair of rows. Depending
on the context, rows \eqn{x} and \eqn{y} are both rows of \eqn{X}, or
\eqn{x} is a row from \eqn{X} and \eqn{y} is a row from from \eqn{Y}.}

\item{Y}{A numerical matrix.}

\item{a}{A scalar vector.}
}
\value{
\code{outer1} and \code{outer2} return a matrix. \code{outer1_matvec} and \code{outer2_matvec}
return a vector. See section "Outer" of the package vignette for details.
}
\description{
Compute "outer" matrices and matrix-vector products based on a function
that operators on pairs of rows. See details.
}
\details{
The \code{outer1} function computes the \eqn{n \times n} symmetric matrix

\deqn{
\text{\texttt outer1}(X, f) =
\begin{bmatrix}
f(x_1, x_1) & \cdots & f(x_1, x_n) \cr
\vdots & \ddots & \vdots \cr
f(x_n, x_1) & \cdots & f(x_n, x_n) \cr
\end{bmatrix}
}

and the \code{outer1_matvec} operation computes the \eqn{n}-dimensional vector

\deqn{
\text{\texttt outer1\_matvec}(X, f, a) =
\begin{bmatrix}
f(x_1, x_1) & \cdots & f(x_1, x_n) \cr
\vdots & \ddots & \vdots \cr
f(x_n, x_1) & \cdots & f(x_n, x_n) \cr
\end{bmatrix}
\begin{bmatrix}
a_1 \cr
\vdots \cr
a_n \cr
\end{bmatrix}.
}

The \code{outer2} operation computes the \eqn{m \times n} matrix

\deqn{
\text{\texttt outer2}(X, Y, f) =
\begin{bmatrix}
f(x_1, y_1) & \cdots & f(x_1, y_n) \cr
\vdots & \ddots & \vdots \cr
f(x_m, y_1) & \cdots & f(x_m, y_n) \cr
\end{bmatrix}
}

and the \code{outer2_matvec} operation computes the \eqn{m}-dimensional vector

\deqn{
\text{\texttt outer2\_matvec}(X, Y, f, a) =
\begin{bmatrix}
f(x_1, y_1) & \cdots & f(x_1, y_n) \cr
\vdots & \ddots & \vdots \cr
f(x_m, y_1) & \cdots & f(x_m, y_n) \cr
\end{bmatrix}
\begin{bmatrix}
a_1 \cr
\vdots \cr
a_n \cr
\end{bmatrix}.
}
}
\examples{
set.seed(1234)
f = function(x,y) { sum( (x - y)^2 ) }
X = matrix(rnorm(12), 6, 2)
Y = matrix(rnorm(10), 5, 2)
outer1(X, f)
outer2(X, Y, f)

a = rep(1, 6)
b = rep(1, 5)
outer1_matvec(X, f, a)
outer2_matvec(X, Y, f, b)

}
