% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmt.R
\name{is.format}
\alias{is.format}
\title{Determine whether an object is a user-defined format}
\usage{
is.format(x)
}
\arguments{
\item{x}{A user-defined format of class "fmt".}
}
\value{
A logical value or TRUE or FALSE.
}
\description{
The \code{is.format} function can be used to determine if an object is a 
user-defined format of class "fmt".
}
\details{
The \code{is.format} function returns TRUE if the object passed is a 
user-defined format.  User-defined formats are defined using the \code{value}
function. See the \code{\link{value}}
function help for further details.
}
\examples{

# Define format
fmt1 <- value(condition(x == "A", "Label A"),
              condition(x == "B", "Label B"), 
              condition(TRUE, "Other"))
              
# Check for format
is.format(fmt1)
is.format("A")
}
\seealso{
\code{\link{value}} to define a format,
\code{\link{condition}} to define the conditions for a format, and 
\code{\link{fapply}} to apply the format to a vector.
}
