% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indices-class.R
\name{indexshifters}
\alias{indexshifters}
\alias{to_reset}
\alias{to_value}
\alias{to_maturity}
\alias{to_reset.default}
\alias{to_value.default}
\alias{to_maturity.default}
\title{Index date shifters}
\usage{
to_reset(dates, index)

to_value(dates, index)

to_maturity(dates, index)

\method{to_reset}{default}(dates, index)

\method{to_value}{default}(dates, index)

\method{to_maturity}{default}(dates, index)
}
\arguments{
\item{dates}{a vector of dates to shift}

\item{index}{an instance of an object that inherits from the \code{Index} class.}
}
\value{
a vector of shifted dates
}
\description{
A collection of methods that shift dates according to index conventions.
}
\details{
The following describes the default methods. \code{to_reset()} treats the input
dates as value dates and shifts these to the corresponding reset or fixing
dates using the index's spot lag; \code{to_value()} treats the input dates as
reset or fixing dates and shifts them to the corresponding value dates using
the index's spot lag; and \code{to_maturity()} treats the input dates as value
dates and shifts these to the index's corresponding maturity date using the
index's tenor.
}
\examples{
library(lubridate)
to_reset(ymd(20170101) + days(0:30), AUDBBSW(months(3)))
to_value(ymd(20170101) + days(0:30), AUDBBSW(months(3)))
to_maturity(ymd(20170101) + days(0:30), AUDBBSW(months(3)))
}
