% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fml_bootstrap.R
\name{fml_bootstrap}
\alias{fml_bootstrap}
\title{fml_bootstrap}
\usage{
fml_bootstrap(parser_inst)
}
\arguments{
\item{parser_inst}{Instance of fml_parser class that comprises command line arguments.}
}
\value{
none
}
\description{
Pipeline function that sets up and runs a resampling experiment.
}
\details{
The experiment is run in parallel.
All results are written to files.
}
\examples{
\dontrun{
parser_inst <-  flowml::create_parser()

parser_inst$pipeline_segment <- "bootstrap"
parser_inst$config <- flowml::fml_example(file = "reg_config.json")
parser_inst$data <- flowml::fml_example(file = "reg_data.csv")
parser_inst$samples_train <- flowml::fml_example(file = "reg_samples_train.txt")
parser_inst$samples_test <- flowml::fml_example(file = "reg_samples_test.txt")
parser_inst$features <- flowml::fml_example(file = "reg_features.txt")
parser_inst$extended_features <- flowml::fml_example(file = "reg_features_extended.txt")
parser_inst$trained <- flowml::fml_example(file = "reg_fit.rds")
parser_inst$permutation <- "none"
parser_inst$result_dir <- tempdir()

flowml::fml_bootstrap(parser_inst = parser_inst)
}

}
\author{
Sebastian Malkusch
}
