% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_fluorimeter_output.R
\name{parse_fluorimeter_output}
\alias{parse_fluorimeter_output}
\title{parse_fluorimeter_output}
\usage{
parse_fluorimeter_output(spec_file = NULL, adjust = TRUE,
  file_type = c("auto", "FelixGXv4.1.0.3096", "Felix32v1.20", "manual"))
}
\arguments{
\item{spec_file}{Path to a \file{*.txt} file as a \code{\link{character}} 
object.}

\item{adjust}{A \code{\link{logical}} indicating of whether (default) or not
acquisition time should be reset to have \code{0} (zero) coincide with the 
addition of dithionite (see 'Details' section).}

\item{file_type}{A string specifying whether or the file was created using
Felix GX or Felix 32 or is a "manual" tab delimited file.}
}
\value{
A data frame with two columns:
\describe{
\item{Time.in.sec}{Numeric. Number of seconds since the start of experiment.}
\item{Fluorescence.Intensity}{Numeric. Intensity of fluorescence (relative 
scale, no official unit).}
}
For Felix GX, if the file contains the information, the return value will  
also have anattribute \code{WavelengthsInNanometres}, which contains the 
excitation and emission wavelengths.
}
\description{
Parse fluorimeter spectra
}
\details{
A function to read fluorimeter output directly. Intended as a helper
function to scramblase activity determinations from dithionite assays.

The function is currently capable to deal with input derived from 
QuantaMaster instruments (Photon Technology International, Inc., Edison, 
New Jersey)running software versions \code{FelixGX v4.1} 
(see \code{\link{parse_felix_gx_output}}) and \code{Felix32 v1.20} (see 
\code{\link{parse_felix_32_output}}). The format used in a given file is 
divined from the data structure and appropriate internal parsing functions  
are called.

If requested the time point of dithionite addition to a sample is determined 
using \pkg{wmtsa}-supplied methodology and the acquisition time reset
accordingly (\code{0} henceforth corresponds to the time of addition).
}
\examples{
library(magrittr)
# Extract example data
analysis_dir <- file.path(tempdir(), "flippant-case-study")
fluor_file <- extract_case_study_data(analysis_dir, "wildtypeEx1_0.txt")
# Parse an exemplary file
parse_fluorimeter_output(fluor_file) \%>\%
  str()
}
\seealso{
\code{scramblase_assay_input_validation},
\code{\link[flippant]{parse_felix_gx_output}}, 
\code{\link[flippant]{parse_felix_32_output}},
\code{\link[flippant]{parse_manual_output}}
}
\author{
Johannes Graumann
}
\keyword{IO}
\keyword{file}
\keyword{manip}
