% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printers.R
\name{save_as_docx}
\alias{save_as_docx}
\title{Save flextable objects in a 'Word' file}
\usage{
save_as_docx(..., values = NULL, path, pr_section = NULL, align = "center")
}
\arguments{
\item{...}{flextable objects, objects, possibly named. If named objects, names are
used as titles.}

\item{values}{a list (possibly named), each element is a flextable object. If named objects, names are
used as titles. If provided, argument \code{...} will be ignored.}

\item{path}{Word file to be created}

\item{pr_section}{a \link[officer:prop_section]{officer::prop_section} object that can be used to define page
layout such as orientation, width and height.}

\item{align}{left, center (default) or right.}
}
\value{
a string containing the full name of the generated file
}
\description{
sugar function to save flextable objects in an Word file.
}
\examples{

tf <- tempfile(fileext = ".docx")

library(officer)
ft1 <- flextable(head(iris))
save_as_docx(ft1, path = tf)


ft2 <- flextable(head(mtcars))
sect_properties <- prop_section(
  page_size = page_size(
    orient = "landscape",
    width = 8.3, height = 11.7
  ),
  type = "continuous",
  page_margins = page_mar()
)
save_as_docx(
  `iris table` = ft1, `mtcars table` = ft2,
  path = tf, pr_section = sect_properties
)
}
\seealso{
\code{\link[=paginate]{paginate()}}

Other flextable print function: 
\code{\link{df_printer}()},
\code{\link{flextable_to_rmd}()},
\code{\link{gen_grob}()},
\code{\link{htmltools_value}()},
\code{\link{knit_print.flextable}()},
\code{\link{plot.flextable}()},
\code{\link{print.flextable}()},
\code{\link{save_as_html}()},
\code{\link{save_as_image}()},
\code{\link{save_as_pptx}()},
\code{\link{save_as_rtf}()},
\code{\link{to_html.flextable}()}
}
\concept{flextable print function}
