% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_special_characters_in_names.R
\name{fix_special_characters_in_names}
\alias{fix_special_characters_in_names}
\title{Remove Special Characters from Data Frame Column and Row Names}
\usage{
fix_special_characters_in_names(df)
}
\arguments{
\item{df}{A data frame with non-alphanumeric characters in the column or row
names.}
}
\value{
A data frame with all non-alphanumeric characters removed from the
column and row names.
}
\description{
This function removes any non-alphanumeric characters from both the row and
column names of a given data frame.
}
\examples{
df <- data.frame("Col1!" = c(1, 2, 3), "Col2?" = c(4, 5, 6))
rownames(df) <- c("Row1@", "Row2#", "Row3$")
fix_special_characters_in_names(df)

}
