% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCOV.R
\name{setFixest_vcov}
\alias{setFixest_vcov}
\alias{getFixest_vcov}
\title{Sets the default type of standard errors to be used}
\usage{
setFixest_vcov(
  no_FE = "iid",
  one_FE = "cluster",
  two_FE = "cluster",
  panel = "cluster",
  all = NULL,
  reset = FALSE
)

getFixest_vcov()
}
\arguments{
\item{no_FE}{Character scalar equal to either: \code{"iid"} (default), or \code{"hetero"}. The type of standard-errors to use by default for estimations without fixed-effects.}

\item{one_FE}{Character scalar equal to either: \code{"iid"}, \code{"hetero"}, or \code{"cluster"} (default). The type of standard-errors to use by default for estimations with \emph{one} fixed-effect.}

\item{two_FE}{Character scalar equal to either: \code{"iid"}, \code{"hetero"}, \code{"cluster"} (default), or \code{"twoway"}. The type of standard-errors to use by default for estimations with \emph{two or more} fixed-effects.}

\item{panel}{Character scalar equal to either: \code{"iid"}, \code{"hetero"}, \code{"cluster"} (default), or \code{"driscoll_kraaay"}. The type of standard-errors to use by default for estimations with the argument \code{panel.id} set up. Note that panel has precedence over the presence of fixed-effects.}

\item{all}{Character scalar equal to either: \code{"iid"}, or \code{"hetero"}. By default is is NULL. If provided, it sets all the SEs to that value.}

\item{reset}{Logical, default is \code{FALSE}. Whether to reset to the default values.}
}
\value{
The function \code{getFixest_vcov()} returns a list with three elements containing the default for estimations i) without, ii) with one, or iii) with two or more fixed-effects.
}
\description{
This functions defines or extracts the default type of standard-errors to computed in \code{fixest} \code{\link[=summary.fixest]{summary}}, and \code{\link[=vcov.fixest]{vcov}}.
}
\examples{

# By default:
# - no fixed-effect (FE): standard
# - one or more FEs: cluster
# - panel: cluster on panel id

data(base_did)
est_no_FE  = feols(y ~ x1, base_did)
est_one_FE = feols(y ~ x1 | id, base_did)
est_two_FE = feols(y ~ x1 | id + period, base_did)
est_panel = feols(y ~ x1 | id + period, base_did, panel.id = ~id + period)

etable(est_no_FE, est_one_FE, est_two_FE)

# Changing the default standard-errors
setFixest_vcov(no_FE = "hetero", one_FE = "iid",
               two_FE = "twoway", panel = "drisc")
etable(est_no_FE, est_one_FE, est_two_FE, est_panel)

# Resetting the defaults
setFixest_vcov(reset = TRUE)


}
