% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crruni.R
\name{crruni}
\alias{crruni}
\title{Competing risks univariable regression: \code{finalfit} model wrapper}
\usage{
crruni(.data, dependent, explanatory, ...)
}
\arguments{
\item{.data}{Data frame or tibble.}

\item{dependent}{Character vector of length 1: name of survival object in
form \code{Surv(time, status)}. \code{Status} default values should be 0
censored (e.g. alive), 1 event of interest (e.g. died of disease of
interest), 2 competing event (e.g. died of other cause).}

\item{explanatory}{Character vector of any length: name(s) of explanatory
variables.}

\item{...}{Other arguments to \code{\link[cmprsk]{crr}}}
}
\value{
A list of univariable \code{\link[cmprsk]{crr}} fitted models class
  \code{crrlist}.
}
\description{
Using \code{finalfit} conventions, produces univariable Competing Risks
Regression models for a set of explanatory variables.
}
\details{
Uses \code{\link[cmprsk]{crr}} with \code{finalfit} modelling conventions.
Output can be passed to \code{\link{fit2df}}.
}
\examples{
library(dplyr)
melanoma = boot::melanoma
melanoma = melanoma \%>\%
  mutate(
    # Cox PH to determine cause-specific hazards
    status_coxph = ifelse(status == 2, 0, # "still alive"
      ifelse(status == 1, 1, # "died of melanoma"
        0)), # "died of other causes is censored"
        
    # Fine and Gray to determine subdistribution hazards
    status_crr = ifelse(status == 2, 0, # "still alive"
      ifelse(status == 1, 1, # "died of melanoma"
        2)), # "died of other causes"
    sex = factor(sex),
    ulcer = factor(ulcer)
  )

dependent_coxph = c("Surv(time, status_coxph)")
dependent_crr = c("Surv(time, status_crr)")
explanatory = c("sex", "age", "ulcer")

# Create single well-formatted table
melanoma \%>\%
  summary_factorlist(dependent_crr, explanatory, column = TRUE, fit_id = TRUE) \%>\%
  ff_merge(
    melanoma \%>\%
      coxphmulti(dependent_coxph, explanatory) \%>\%
      fit2df(estimate_suffix = " (Cox PH multivariable)")
    ) \%>\%
  ff_merge(
    melanoma \%>\%
      crrmulti(dependent_crr, explanatory) \%>\%
      fit2df(estimate_suffix = " (competing risks multivariable)")
    ) \%>\%
  select(-fit_id, -index) \%>\%
  dependent_label(melanoma, dependent_crr)
}
\seealso{
\code{\link{fit2df}, \link{finalfit_merge}}

Other finalfit model wrappers: \code{\link{coxphmulti}},
  \code{\link{coxphuni}}, \code{\link{crrmulti}},
  \code{\link{glmmixed}}, \code{\link{glmmulti_boot}},
  \code{\link{glmmulti}}, \code{\link{glmuni}},
  \code{\link{lmmixed}}, \code{\link{lmmulti}},
  \code{\link{lmuni}}, \code{\link{svyglmmulti}},
  \code{\link{svyglmuni}}
}
\concept{finalfit model wrappers}
