% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fidofit_methods.R
\name{sample_prior.pibblefit}
\alias{sample_prior.pibblefit}
\title{Sample from the prior distribution of pibblefit object}
\usage{
\method{sample_prior}{pibblefit}(
  m,
  n_samples = 2000L,
  pars = c("Eta", "Lambda", "Sigma"),
  use_names = TRUE,
  ...
)
}
\arguments{
\item{m}{object of class pibblefit}

\item{n_samples}{number of samples to produce}

\item{pars}{parameters to sample}

\item{use_names}{should names be used if available}

\item{...}{currently ignored}
}
\value{
A pibblefit object
}
\description{
Note this can be used to sample from prior and then predict can
be called to get counts or LambdaX (\code{\link{predict.pibblefit}})
}
\details{
Could be greatly speed up in the future if needed by sampling
directly from cholesky form of inverse wishart (currently implemented as 
header in this library - see MatDist.h).
}
\examples{
\donttest{
# Sample prior of already fitted  pibblefit object
sim <- pibble_sim()
attach(sim)
fit <- pibble(Y, X)
head(sample_prior(fit))

# Sample prior as part of model fitting
m <- pibblefit(N=as.integer(sim$N), D=as.integer(sim$D), Q=as.integer(sim$Q), 
                iter=2000L, upsilon=upsilon, 
                Xi=Xi, Gamma=Gamma, Theta=Theta, X=X, 
                coord_system="alr", alr_base=D)
m <- sample_prior(m)
plot(m) # plot prior distribution (defaults to parameter Lambda) 
}
}
