% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fhircrack.R
\name{fhir_melt}
\alias{fhir_melt}
\title{Melt multiple entries}
\usage{
fhir_melt(
  indexed_data_frame,
  columns,
  brackets = c("<", ">"),
  sep = " -+- ",
  id_name = "resource_identifier",
  all_columns = FALSE
)
}
\arguments{
\item{indexed_data_frame}{A data frame with indexed multiple entries.}

\item{columns}{A character vector specifying the names of all columns that should be molten simultaneously.
It is advisable to only melt columns simultaneously that belong to the same (repeating) attribute!}

\item{brackets}{A character vector of length 2, defining the brackets used for the indices.}

\item{sep}{A string defining the separator that was used when pasting together multiple entries in \code{\link{fhir_crack}}.}

\item{id_name}{A string, the name of the column that will hold the identification of the origin of the new rows.}

\item{all_columns}{A logical scalar. Return all columns or only the ones specified in \code{columns}?}
}
\value{
A data frame where each entry from the variables in \code{columns} appears in a separate row.
}
\description{
This function divides multiple entries in an indexed data frame as produced by \code{\link{fhir_crack}}
into separate observations.
}
\details{
Every row containing values that consist of multiple entries on the variables specified by the argument \code{columns}
will be turned into multiple rows, one for each entry. Values on other variables will be repeated in all the new rows.

The new data frame will contain only the molten variables (if \code{all_cloumns = FALSE}) or all variables
(if \code{all_columns = TRUE}) as well as an additional variable \code{resource_identificator} that maps which rows came
from the same origin. The name of this column can be changed in the argument \code{id_name}.

For a more detailed description on how to use this function please see the package vignette.
}
\examples{
#generate example
bundle <- xml2::read_xml(
"<Bundle>

    <Patient>
        <id value='id1'/>
        <address>
            <use value='home'/>
            <city value='Amsterdam'/>
            <type value='physical'/>
           <country value='Netherlands'/>
        </address>
        <birthDate value='1992-02-06'/>
    </Patient>

    <Patient>
        <id value='id2'/>
        <address>
            <use value='home'/>
            <city value='Rome'/>
            <type value='physical'/>
            <country value='Italy'/>
        </address>
        <address>
            <use value='work'/>
            <city value='Stockholm'/>
            <type value='postal'/>
            <country value='Sweden'/>
        </address>
        <birthDate value='1980-05-23'/>
    </Patient>
</Bundle>"
)

#crack fhir resources
dfs <- fhir_crack(bundles = list(bundle), design = list(Patients = list(resource = ".//Patient")),
                  brackets = c("[","]"))

#find all column names associated with attribute address
col_names <- fhir_common_columns(dfs$Patients, "address")

#original data frame
dfs$Patients

#only keep address columns
fhir_melt(indexed_data_frame = dfs$Patients, columns = col_names,
          brackets = c("[","]", sep = " "))

#keep all columns
fhir_melt(indexed_data_frame = dfs$Patients, columns = col_names,
          brackets = c("[","]"), sep = " ", all_columns = TRUE)
}
