% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_dir_search}
\alias{get_dir_search}
\title{Extract directional search points during the optimisation}
\usage{
get_dir_search(dt, ratio = 5, ...)
}
\arguments{
\item{dt}{a data object collected by the projection pursuit guided tour optimisation in the \code{tourr} package}

\item{ratio}{numeric; a buffer value to deviate directional search points from the anchor points}

\item{...}{arguments passed to \code{compute_pca()}}
}
\value{
a tibble object containing the directional search bases in pseudo derivative search
}
\description{
Extract directional search points during the optimisation
}
\examples{
holes_1d_geo \%>\%
  compute_pca() \%>\%
  purrr::pluck("aug") \%>\%
  get_dir_search()
}
\seealso{
Other get functions: 
\code{\link{get_anchor}()},
\code{\link{get_basis_matrix}()},
\code{\link{get_best}()},
\code{\link{get_interp_last}()},
\code{\link{get_interp}()},
\code{\link{get_interrupt}()},
\code{\link{get_search_count}()},
\code{\link{get_search}()},
\code{\link{get_space_param}()},
\code{\link{get_start}()},
\code{\link{get_theo}()}
}
\concept{get functions}
