% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runallmodels.R
\name{rfgini}
\alias{rfgini}
\title{Random Forest cumulative MeanDecreaseGini feature selection.
Implements a feature selection approach based on cumulative MeanDecreaseGini using Random Forests trained on multiple subsamples.}
\usage{
rfgini(num_runs = 100, num_trees = 30, file_path = file_path)
}
\arguments{
\item{num_runs}{Number of subsamples to use for voting scheme (default: 100)}

\item{num_trees}{Number of trees for random forest (selected using select_rf_numtrees)}

\item{file_path}{Where the num_runs subsample files are found (e.g. if sample 10 is at 'subsamples/sample10.csv' then file_path should be 'subsamples/sample'). There must be enough samples to fulfill num_runs runs.}
}
\value{
The function will output a data.frame with cumulative mean decrease in Gini for each feature in the first columns (each row is a feature) and the rest of the column containing mean decrease in Gini for each of the num_runs runs.
}
\description{
Random Forest cumulative MeanDecreaseGini feature selection.
Implements a feature selection approach based on cumulative MeanDecreaseGini using Random Forests trained on multiple subsamples.
}
\examples{
rfgini(
  num_runs=5,
  num_trees=30,
  file_path=paste(system.file('samples/subsamples',package = "feamiR"),'/sample',sep=''))
}
\keyword{Gini}
\keyword{feature}
\keyword{forest}
\keyword{random}
\keyword{rf}
\keyword{selection}
