% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.R
\name{evaluation.adjr2}
\alias{evaluation.adjr2}
\title{Adjusted R2 evaluation of regression predictions}
\usage{
evaluation.adjr2(predictions, gt, nrow = length(predictions), ncol, ...)
}
\arguments{
\item{predictions}{The predictions of a regression model (\code{vector}).}

\item{gt}{The ground truth (\code{vector}).}

\item{nrow}{Number of observations.}

\item{ncol}{Number of variables}

\item{...}{Other parameters.}
}
\value{
The evaluation of the predictions (numeric value).
}
\description{
Evaluation predictions of a regression model according to R2
}
\examples{
require (datasets)
data (trees)
d = splitdata (trees, 3)
model.linreg = LINREG (d$train.x, d$train.y)
pred.linreg = predict (model.linreg, d$test.x)
evaluation.r2 (pred.linreg, d$test.y)
}
\seealso{
\code{\link{evaluation.msep}}, \code{\link{evaluation}}
}
