% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_principal_directions.R
\name{curve_principal_directions}
\alias{curve_principal_directions}
\title{Curve PCA}
\usage{
curve_principal_directions(v, K, mu, len = NA, no = 3, N = 5, mode = "O")
}
\arguments{
\item{v}{array of sizes \eqn{n \times T \times N1} for \eqn{N1} shooting
vectors of dimension \eqn{n} evaluated on a grid of \eqn{T} points}

\item{K}{matrix of sizes \eqn{nT \times nT} of covariance matrix}

\item{mu}{matrix of sizes \eqn{n \times T} of mean srvf}

\item{len}{length of original curves (default = \code{NA})}

\item{no}{number of components}

\item{N}{number of samples on each side of mean}

\item{mode}{Open (\code{"O"}) or Closed (\code{"C"}) curves}
}
\value{
Returns a list containing \item{s}{singular values}
\item{U}{singular vectors}
\item{coef}{principal coefficients}
\item{pd}{principal directions}
}
\description{
Calculate principal directions of a set of curves
}
\examples{
out <- curve_karcher_mean(beta[, , 1, 1:2], maxit = 2)
# note: use more shapes, small for speed
K <- curve_karcher_cov(out$v)
out <- curve_principal_directions(out$v, K, out$mu)
}
\references{
Srivastava, A., Klassen, E., Joshi, S., Jermyn, I., (2011). Shape analysis of elastic curves in euclidean spaces. Pattern Analysis and Machine Intelligence, IEEE Transactions on 33 (7), 1415-1428.
}
\keyword{alignment}
\keyword{srvf}
