% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SparseMarginalFPCA.R
\name{SparseMarginalFPCA}
\alias{SparseMarginalFPCA}
\title{Marginal Functional Principal Component Analysis for repeated sparse functional data.}
\usage{
SparseMarginalFPCA(
  sSup,
  Lt,
  Ly,
  fpca.op1 = list(),
  fpca.op2 = list(),
  pc.j = NULL,
  pc.k = NULL,
  bw_mu_min = NULL,
  bw_mu_max = NULL
)
}
\arguments{
\item{sSup}{A vector of length num.ages representing the common grid for every individual in the direction of (age) dimension 2.}

\item{Lt}{A list of n vectors containing the observation time points for every individual, such that the ith element of the list comprises the num.years.i points in the direction of (year) dimension 1 at which the functional-valued stochastic process is observed for the ith individual.}

\item{Ly}{A list of n matrices containing the observed values for every individual, such that the ith element is an num.ages by num.years.i matrix of observed values for the ith individual.}

\item{fpca.op1}{A list of options control parameters specified by \code{list(name=value)} for FPCA in direction of (age) dimension 2; check fdapace::FPCA for available control options and default settings.}

\item{fpca.op2}{A list of options control parameters specified by \code{list(name=value)} for FPCA in direction of (year) dimension 1; check fdapace::FPCA for available control options and default settings.}

\item{pc.j}{A scalar denoting the maximum number of components to consider for FPCA in direction of (age) dimension 2; default: chosen by FVE if NULL.}

\item{pc.k}{A vector of length pc.j denoting the maximum number of components to consider for nested FPCA in direction of (year) dimension 1; default: chosen by FVE if NULL.}

\item{bw_mu_min}{The minimum bandwidth value considered for bandwidth selection in mean function estimation, such that the final bandwidth chosen by 5-fold cross validation is above this minimum value; default:NULL, bandwidth chosen by 5-fold cross validation over the default range.}

\item{bw_mu_max}{The maximum bandwidth value considered for bandwidth selection in mean function estimation, such that the final bandwidth chosen by 5-fold cross validation is below this value; default:NULL, bandwidth chosen by 5-fold cross validation over the default range.}
}
\value{
A list containing the following fields:
\item{age.grid}{A vector of length num.ages, representing the grid used for fitting FPCA in the direction of (age) dimension 2, same as sSup.}
\item{year.grid}{A vector of length nWorkGrid, representing the grid used for fitting FPCA in the direction of (year) dimension 1.}
\item{mu}{An num.ages by nWorkGrid matrix containing bivariate mean function estimate.}
\item{bwMu}{The selected bandwidth for mean function estimation.}
\item{pc.j}{A scalar denoting the selected number of components for FPCA in direction of (age) dimension 2.}
\item{pc.k}{A vector of length pc.j, denoting the selected number of components for FPCA in direction of (year) dimension 1.}
\item{res.psi}{A list containing the FPCA output for FPCA in direction of (age) dimension 2.}
\item{res.phi}{A list containing the FPCA output for FPCA in direction of (year) dimension 1.}
\item{scores}{A list of pc.j matrices containing the estimated scores, such that the jth element of the list is an n by pc.k[j] matrix with its ith row comprising the estimated scores \eqn{chi_{j,1}},..., \eqn{chi_{j,pc.k[j]}} for the ith individual.}
\item{psi}{An num.ages by pc.j matrix containing the estimated eigenfunctions from FPCA in direction of (age) dimension 2.}
\item{phi}{A list of pc.j matrices containing the estimated eigen functions from FPCA in direction of (year) dimension 1, such that the jth element of the list is an nWorkGrid by pc.k[j] matrix.}
\item{VarOrdered}{A list of pc.j vectors, containing the variance explained by each term. The terms are ordered by \eqn{var(chi_{jk})}. One can select the best model by truncating at a desired level of FVE, and use names(VarOrdered) to see the corresponding model terms.}
}
\description{
Note: The code works for sparse functional data.
}
\details{
This code works for sparse functional data, with the notion of sparsity defined as follows. Sparsity in the year direction (dimension 1) means that the years at which the data are observed for a country (or individual unit) are sparsely distributed. However for the ith county (or individual unit), if the data are available for a particular year (dimension 1), then it is available for all the ages (dimension 2) in sSup corresponding to that specific year. Thus along (age) dimension 2, data type is dense. The 'usergrid' control option in FPCA indicates whether to use observation grid for fitting, if false FPCA will use equidistant grid. logical - default:FALSE. Along (age) dimension 2, FPCA is done for only for sSup as observation grid. Depending on the choice of usergrid for 'fpca.op2', FPCA in (year) dimension 1 is either fitted on the observed (pooled) grid or on the internal regular grid of default length 51.
}
\examples{
\donttest{
Ly <- lapply(1:20, function(i){matrix(rnorm(13*(i)), 13, i)})
Lt <- lapply(1:20, function(i){1:(i)})
sSup <- c(1:13)
pc.j <- 2
pc.k <- c(2,3)
fpca.op1 <- NULL
fpca.op2 <- NULL
bw_mu_max <- NULL
bw_mu_min <- NULL
res <- SparseMarginalFPCA(sSup, Lt, Ly, fpca.op1, fpca.op2, pc.j, pc.k, bw_mu_min, bw_mu_max)
}

}
\references{
\itemize{
\item \cite{Chen, K., Delicado, P., & Müller, H. G. (2017). Modelling function-valued stochastic processes, with applications to fertility dynamics. Journal of the Royal Statistical Society Series B: Statistical Methodology, 79(1), 177-196.}
\item \cite{Chen, K., & Müller, H. G. (2012). Modeling repeated functional observations. Journal of the American Statistical Association, 107(500), 1599-1609.}
\item \cite{Hall, P.,  Müller, H.G. and Wang, J.L. (2006). Properties of principal component methods for functional and longitudinal data analysis. Annals of Statistics, 34(3), 1493-1517.}
\item \cite{Yao, F., Müller, H. G., & Wang, J. L. (2005). Functional data analysis for sparse longitudinal data. Journal of the American statistical association, 100(470), 577-590.}
}
}
