% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.ring.lattice.R
\name{net.ring.lattice}
\alias{net.ring.lattice}
\title{\emph{k} - regular ring lattice}
\usage{
net.ring.lattice(n, k)
}
\arguments{
\item{n}{Number of nodes in the network.}

\item{k}{Number of edges per node.}
}
\value{
A list containing the nodes of the network and their respective neighbors.
}
\description{
Simulate a network with a \emph{k} -regular ring lattice structure.
}
\details{
The \emph{n} nodes are placed on a circle and each node is connected to the nearest \emph{k} neighbors.
}
\examples{
\dontrun{
x <- net.ring.lattice(1000, 10)}
}
\author{
Xu Dong, Nazrul Shaikh
}
\references{
Duncan J Watts and Steven H Strogatz: Collective dynamics of 'small world' networks, Nature 393, 440-442, 1998.
}

