% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.fastml.R
\name{summary.fastml}
\alias{summary.fastml}
\title{Summary Function for fastml (Using yardstick for ROC Curves)}
\usage{
\method{summary}{fastml}(
  object,
  algorithm = "best",
  type = c("all", "metrics", "params", "conf_mat"),
  sort_metric = NULL,
  ...
)
}
\arguments{
\item{object}{An object of class \code{fastml}.}

\item{algorithm}{A vector of algorithm names to display summary. Default is \code{"best"}.}

\item{type}{Character vector indicating which outputs to produce.
Options are \code{"all"} (all available outputs),
\code{"metrics"} (performance metrics),
\code{"params"} (best hyperparameters), and
\code{"conf_mat"} (confusion matrix).
Default is \code{"all"}.}

\item{sort_metric}{The metric to sort by. Default uses optimized metric.}

\item{...}{Additional arguments.}
}
\value{
Prints summary of fastml models.
}
\description{
Summarizes the results of machine learning models trained using the `fastml` package.
Depending on the task type (classification or regression), it provides customized output such as
performance metrics, best hyperparameter settings, and confusion matrices.
It is designed to be informative and readable, helping users quickly interpret model results.
}
\details{
For classification tasks, the summary includes metrics such as Accuracy, F1 Score, Kappa,
Precision, ROC AUC, Sensitivity, and Specificity. A confusion matrix is also provided for the best model(s).
For regression tasks, the summary reports RMSE, R-squared, and MAE.

Users can control the type of output with the `type` argument:
`metrics` displays model performance metrics.
`params` shows the best hyperparameter settings.
`conf_mat` prints confusion matrices (only for classification).
`all` includes all of the above.

If multiple algorithms are trained, the summary highlights the best model based on the optimized metric.
}
