% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_methods.R
\name{summary.fastglm}
\alias{summary.fastglm}
\title{summary method for fastglm fitted objects}
\usage{
\method{summary}{fastglm}(object, dispersion = NULL, ...)
}
\arguments{
\item{object}{fastglm fitted object}

\item{dispersion}{the dispersion parameter for the family used. 
Either a single numerical value or \code{NULL} (the default), when it is inferred from \code{object}.}

\item{...}{not used}
}
\value{
a summary.fastglm object
}
\description{
summary method for fastglm fitted objects
}
\examples{

x <- matrix(rnorm(10000 * 10), ncol = 10)
y <- 1 * (0.25 * x[,1] - 0.25 * x[,3] > rnorm(10000))

fit <- fastglm(x, y, family = binomial())

#summary(fit)


}
