% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcpd_wrappers.R
\name{fastcpd.lm}
\alias{fastcpd.lm}
\alias{fastcpd_lm}
\title{Find change points efficiently in linear regression models}
\usage{
fastcpd.lm(data, ...)

fastcpd_lm(data, ...)
}
\arguments{
\item{data}{A matrix or a data frame with the response variable as the first
column.}

\item{...}{Other arguments passed to \code{\link{fastcpd}}, for example,
\code{segment_count}.}
}
\value{
A class \code{fastcpd} object.
}
\description{
\code{"fastcpd_lm"} and \code{"fastcpd.lm"} are wrapper
functions of \code{\link{fastcpd}} to find change points in linear
regression models. The function is similar to \code{"fastcpd"} except that
the data is by default a matrix or data frame with the response variable
as the first column and thus a formula is not required here.
}
\examples{
for (package in c("ggplot2", "mvtnorm")) {
  if (!requireNamespace(package, quietly = TRUE)) utils::install.packages(
    package, repos = "https://cloud.r-project.org", quiet = TRUE
  )
}

set.seed(1)
n <- 300
p <- 4
x <- mvtnorm::rmvnorm(n, rep(0, p), diag(p))
theta_0 <- rbind(c(1, 3.2, -1, 0), c(-1, -0.5, 2.5, -2), c(0.8, 0, 1, 2))
y <- c(
  x[1:100, ] \%*\% theta_0[1, ] + rnorm(100, 0, 3),
  x[101:200, ] \%*\% theta_0[2, ] + rnorm(100, 0, 3),
  x[201:300, ] \%*\% theta_0[3, ] + rnorm(100, 0, 3)
)
result <- fastcpd.lm(cbind(y, x))
summary(result)
plot(result)
}
