% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gCD.R
\name{gCD}
\alias{gCD}
\alias{print.gCD}
\alias{plot.gCD}
\title{Generalized Cook's Distance}
\usage{
gCD(data, model, progress = TRUE, ...)

\method{print}{gCD}(x, ncases = 10, DFBETAS = FALSE, ...)

\method{plot}{gCD}(
  x,
  y = NULL,
  main = "Generalized Cook Distance",
  type = c("p", "h"),
  ylab = "gCD",
  ...
)
}
\arguments{
\item{data}{matrix or data.frame}

\item{model}{if a single numeric number declares number of factors to extract in
exploratory factor analysis (requires complete dataset, i.e., no missing).
If \code{class(model)} is a sem (semmod), or lavaan (character),
then a confirmatory approach is performed instead}

\item{progress}{logical; display the progress of the computations in the console?}

\item{...}{additional parameters to be passed}

\item{x}{an object of class \code{gCD}}

\item{ncases}{number of extreme cases to display}

\item{DFBETAS}{logical; return DFBETA matrix in addition to gCD? If TRUE, a list is returned}

\item{y}{a \code{NULL} value ignored by the plotting function}

\item{main}{the main title of the plot}

\item{type}{type of plot to use, default displays points and lines}

\item{ylab}{the y label of the plot}
}
\description{
Compute generalize Cook's distances (gCD's) for exploratory
and confirmatory FA. Can return DFBETA matrix if requested.
If mirt is used, then the values will be associated with the unique response patterns instead.
}
\details{
Note that \code{gCD} is not limited to confirmatory factor analysis and
can apply to nearly any model being studied
where detection of influential observations is important.
}
\examples{

\dontrun{

#run all gCD functions using multiple cores
setCluster()

#Exploratory
nfact <- 3
(gCDresult <- gCD(holzinger, nfact))
(gCDresult.outlier <- gCD(holzinger.outlier, nfact))
plot(gCDresult)
plot(gCDresult.outlier)

#-------------------------------------------------------------------
#Confirmatory with sem
model <- sem::specifyModel()
   F1 -> Remndrs,    lam11
	  F1 -> SntComp,    lam21
	  F1 -> WrdMean,    lam31
	  F2 -> MissNum,    lam41
	  F2 -> MxdArit,    lam52
	  F2 -> OddWrds,    lam62
	  F3 -> Boots,      lam73
  F3 -> Gloves,     lam83
	  F3 -> Hatchts,    lam93
	  F1 <-> F1,   NA,     1
	  F2 <-> F2,   NA,     1
	  F3 <-> F3,   NA,     1

(gCDresult2 <- gCD(holzinger, model))
(gCDresult2.outlier <- gCD(holzinger.outlier, model))
plot(gCDresult2)
plot(gCDresult2.outlier)

#-------------------------------------------------------------------
#Confirmatory with lavaan
model <- 'F1 =~  Remndrs + SntComp + WrdMean
F2 =~ MissNum + MxdArit + OddWrds
F3 =~ Boots + Gloves + Hatchts'

(gCDresult2 <- gCD(holzinger, model, orthogonal=TRUE))
(gCDresult2.outlier <- gCD(holzinger.outlier, model, orthogonal=TRUE))
plot(gCDresult2)
plot(gCDresult2.outlier)

# categorical data with mirt
library(mirt)
data(LSAT7)
dat <- expand.table(LSAT7)
model <- mirt.model('F = 1-5')
result <- gCD(dat, model)
plot(result)

mod <- mirt(dat, model)
res <- residuals(mod, type = 'exp')
cbind(res, gCD=round(result$gCD, 3))

}
}
\references{
Chalmers, R. P. & Flora, D. B. (2015). faoutlier: An R Package for Detecting
  Influential Cases in Exploratory and Confirmatory Factor Analysis.
  \emph{Applied Psychological Measurement, 39}, 573-574. \doi{10.1177/0146621615597894}

Flora, D. B., LaBrish, C. & Chalmers, R. P. (2012). Old and new ideas for data
screening and assumption testing for exploratory and confirmatory factor analysis.
 \emph{Frontiers in Psychology, 3}, 1-21. \doi{10.3389/fpsyg.2012.00055}
}
\seealso{
\code{\link{LD}}, \code{\link{obs.resid}}, \code{\link{robustMD}}, \code{\link{setCluster}}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
\keyword{cooks}
