% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{read_makefile}
\alias{read_makefile}
\title{Read a \command{Makefile} Into a \code{Makelist}}
\usage{
read_makefile(path, clean_sink = FALSE)
}
\arguments{
\item{path}{The path to the file.}

\item{clean_sink}{Remove sinks identical to corresponding targets from the
list? Since \code{makelists} are parsed, missing sinks are set to the
corresponding targets, but this makes them harder to read.}
}
\value{
The \code{makelist}.
}
\description{
Read a \command{Makefile} Into a \code{Makelist}
}
\note{
This function will not read arbitrary \command{Makefiles}, just those
created via \code{\link{write_makefile}}! If you modify such a
\command{Makefile}
make sure you only add simple rules like the ones you see in that file.
}
\examples{
make_file <- file.path(tempdir(), "Makefile")
write_makefile(provide_make_list(), path = make_file)
str(make_list <- read_makefile(path = make_file))
}
