% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ezcox_parallel.R
\name{ezcox_parallel}
\alias{ezcox_parallel}
\title{Parallelly Run Cox Analysis in Batch Mode}
\usage{
ezcox_parallel(
  data,
  covariates,
  controls = NULL,
  time = "time",
  status = "status",
  batch_size = 100,
  global_method = c("likelihood", "wald", "logrank"),
  keep_models = FALSE,
  return_models = FALSE,
  model_dir = file.path(tempdir(), "ezcox"),
  parallel = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{data}{a \code{data.frame} containing variables, time and os status.}

\item{covariates}{column names specifying variables.}

\item{controls}{column names specifying controls.}

\item{time}{column name specifying time, default is 'time'.}

\item{status}{column name specifying event status, default is 'status'.}

\item{batch_size}{processing size in a batch.}

\item{global_method}{method used to obtain global p value for cox model,
should be one of "likelihood", "wald", "logrank".
The likelihood-ratio test, Wald test, and score logrank statistics.
These three methods are asymptotically equivalent. For large enough N,
they will give similar results. For small N, they may differ somewhat.
The Likelihood ratio test has better behavior for small sample sizes,
so it is generally preferred.}

\item{keep_models}{If \code{TRUE}, keep models as local files.}

\item{return_models}{default \code{FALSE}. If \code{TRUE}, return a \code{list} contains
cox models.}

\item{model_dir}{a path for storing model results.}

\item{parallel}{if \code{TRUE}, do parallel computation by \strong{furrr} package.}

\item{verbose}{if \code{TRUE}, print extra info. If \code{parallel} is \code{TRUE},
set \code{verbose} to \code{FALSE} may speed up.}
}
\value{
a \code{ezcox} object
}
\description{
Parallelly Run Cox Analysis in Batch Mode
}
\examples{

library(survival)
ezcox_parallel(lung, covariates = c("sex", "ph.ecog"), controls = "age")
}
\author{
Shixiang Wang \href{mailto:w_shixiang@163.com}{w_shixiang@163.com}
}
