% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_display_coords.R
\name{extract_display_coords}
\alias{extract_display_coords}
\alias{extract_display_coords.data.frame}
\alias{extract_display_coords.eyelinkRecording}
\title{Extract display coordinates from an event message}
\usage{
extract_display_coords(
  object,
  message_prefix = "DISPLAY_COORDS",
  silent = FALSE
)

\method{extract_display_coords}{data.frame}(
  object,
  message_prefix = "DISPLAY_COORDS",
  silent = FALSE
)

\method{extract_display_coords}{eyelinkRecording}(
  object,
  message_prefix = "DISPLAY_COORDS",
  silent = FALSE
)
}
\arguments{
\item{object}{Either an \code{\link{eyelinkRecording}} object or data.frame with events,
i.e., \code{events} slot of the \code{\link{eyelinkRecording}} object.}

\item{message_prefix}{Beginning of the message string that identifies the DISPLAY_COORDS message.
Defaults to \code{"DISPLAY_COORDS"}.}

\item{silent}{Whether to suppress a warning when DISPLAY_COORDS message is missing. Default to \code{FALSE}.}
}
\value{
A \code{\link{eyelinkRecording}} object with an additional \code{display_coords} slot (if that was \code{object} type),
Either a four element numeric vector with display coordinates, or \code{NULL} if \code{object} was an \code{events} table of
\code{\link{eyelinkRecording}} object. See \code{\link{eyelinkRecording}} for details.
}
\description{
Extracts display coordinates from a message that adheres to a
\code{<message_prefix> <label>} format. Please note that this function called
during the \code{\link{read_edf}} call with \code{silent = TRUE}. If \code{display_coords}
are missing from the \code{\link{eyelinkRecording}}, run this method to see the warnings.
}
\examples{
data(gaze)

# by passing the recording
gaze <- extract_display_coords(gaze)

# by passing events table
display_coords <- extract_display_coords(gaze$events)
}
\seealso{
read_edf, eyelinkRecording
}
