% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_to_columns.R
\name{text_to_columns}
\alias{text_to_columns}
\alias{text_to_columns_csv}
\alias{text_to_columns_csv2}
\alias{text_to_columns_tab}
\alias{text_to_columns_tab2}
\title{Make data.frame from text}
\usage{
text_to_columns(text, header = TRUE, sep = "", quote = "",
  dec = ".", encoding = "unknown", ...)

text_to_columns_csv(text, header = TRUE, sep = ",", quote = "",
  dec = ".", encoding = "unknown", ...)

text_to_columns_csv2(text, header = TRUE, sep = ";", quote = "",
  dec = ",", encoding = "unknown", ...)

text_to_columns_tab(text, header = TRUE, sep = "\\t", quote = "",
  dec = ".", encoding = "unknown", ...)

text_to_columns_tab2(text, header = TRUE, sep = "\\t", quote = "",
  dec = ",", encoding = "unknown", ...)
}
\arguments{
\item{text}{character/vector of characters}

\item{header}{a logical value indicating whether the \code{text} contains the
names of the variables as its first line.}

\item{sep}{the field separator character. Values on each line of the file are
separated by this character. If sep = "" (the default for \code{text_to_columns}) the
separator is 'white space', that is one or more spaces, tabs, newlines or
carriage returns.}

\item{quote}{the set of quoting characters. To disable quoting altogether, use quote = "".}

\item{dec}{the character used in the file for decimal points.}

\item{encoding}{encoding to be assumed for input strings. It is used to mark
character strings as known to be in Latin-1 or UTF-8 (see \link[utils]{read.table}).}

\item{...}{further parameters which will be passed to \link[utils]{read.table}.}
}
\value{
data.frame
}
\description{
Convert delimited text lines to data.frame. Blank lines are always skipped,
trailing whitespaces are trimmed. You can use comments with '#' inside your text.
For details see \link[utils]{read.table}.
}
\examples{
text_to_columns("
# simple data.frame 
     a b   c
     1 2.5 a
     4 5.5 b
     7 8.5 c
")

}
