% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/names2labels.R
\name{names2labels}
\alias{n2l}
\alias{names2labels}
\title{Replace data.frame/list names with corresponding variables labels.}
\usage{
names2labels(x, exclude = NULL, keep_names = FALSE)

n2l(x, exclude = NULL, keep_names = FALSE)
}
\arguments{
\item{x}{data.frame/list.}

\item{exclude}{logical/integer/character columns which names should be left
unchanged. Only applicable to list/data.frame.}

\item{keep_names}{logical. If TRUE original column names will be appended to
labels in round brackets. Only applicable to list/data.frame.}
}
\value{
Object of the same type as x but with variable labels instead of
  names.
}
\description{
\code{names2labels} replaces data.frame/list names with corresponding 
variables labels. If there are no labels for some variables their names
remain unchanged. \code{n2l} is just shortcut for \code{names2labels}.
}
\examples{
data(mtcars)
mtcars = modify(mtcars,{
                var_lab(mpg) = "Miles/(US) gallon"
                var_lab(cyl) = "Number of cylinders"
                var_lab(disp) = "Displacement (cu.in.)"
                var_lab(hp) = "Gross horsepower"
                var_lab(drat) = "Rear axle ratio"
                var_lab(wt) = "Weight (lb/1000)"
                var_lab(qsec) = "1/4 mile time"
                var_lab(vs) = "V/S"
                var_lab(am) = "Transmission (0 = automatic, 1 = manual)"
                var_lab(gear) = "Number of forward gears"
                var_lab(carb) = "Number of carburetors"
})

# without original names
# note: we exclude dependent variable 'mpg' from conversion to use its short name in formula
summary(lm(mpg ~ ., data = names2labels(mtcars, exclude = "mpg")))
# with names
summary(lm(mpg ~ ., data = names2labels(mtcars, exclude = "mpg", keep_names = TRUE)))
}
\seealso{
\link{values2labels}, \link{f}, \link{val_lab},  \link{var_lab}
}

