% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_rows.R
\name{add_rows}
\alias{add_rows}
\alias{add_rows.data.frame}
\title{Add rows to data.frame/matrix/table}
\usage{
add_rows(...)

\method{add_rows}{data.frame}(..., nomatch_columns = c("add", "drop", "stop"))
}
\arguments{
\item{...}{data.frame/matrix/table for binding}

\item{nomatch_columns}{action if there are non-matching columns between
data.frames. Possible values are \code{"add"}, \code{"drop"}, \code{"stop"}.
\code{"add"} will combine all columns, \code{"drop"} will leave only common
columns, \code{"stop"} will raise an error.}
}
\value{
See \link[base:cbind]{rbind}, \link{cro}, \link{cro_fun}, \link{fre}, \link{tables}
}
\description{
Take a sequence of vector, matrix or data-frame arguments and combine by
rows. Contrary to \link[base:cbind]{rbind} it handles non-matching column
names. 
There is also special method for the results of
\link{cro}/\link{cro_fun}/\link{tables}/\link{fre}.
}
\examples{
a = data.frame(x = 1:5, y = 6:10)
b = data.frame(y = 6:10, z = 11:15)

add_rows(a, b) # x, y, z

add_rows(a, b, nomatch_columns = "drop")  # y

}
