% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ch03CTT.R
\name{CTT}
\alias{CTT}
\title{Classical Test Theory}
\usage{
CTT(U, na = NULL, Z = NULL, w = NULL)
}
\arguments{
\item{U}{U is a data matrix of the type matrix or data.frame.}

\item{na}{na argument specifies the numbers or characters to be treated as missing values.}

\item{Z}{Z is a missing indicator matrix of the type matrix or data.frame}

\item{w}{w is item weight vector}
}
\value{
Returns a list of class c("exametrika", "CTT") containing two data frames:
\itemize{
\item Reliability: A data frame with overall reliability coefficients
(Alpha and Omega) calculated using different correlation matrices
(Covariance, Phi, and Tetrachoric)
\item ReliabilityExcludingItem: A data frame showing alpha coefficients
when each item is excluded, calculated using different correlation matrices
}
}
\description{
This function calculates the overall alpha and omega coefficients for
the given data matrix. It also computes the alpha coefficient for
each item, assuming that item is excluded.
}
\examples{
\donttest{
# using sample dataset
CTT(J15S500)
}
}
