% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{adapt_charging_features}
\alias{adapt_charging_features}
\title{Adapt charging features}
\usage{
adapt_charging_features(
  sessions,
  time_resolution = 15,
  power_resolution = 0.01
)
}
\arguments{
\item{sessions}{tibble, sessions data set in standard format marked by \code{{evprof}} package
(see \href{https://mcanigueral.github.io/evprof/articles/sessions-format.html}{this article})}

\item{time_resolution}{integer, time resolution (in minutes) of the sessions' datetime variables}

\item{power_resolution}{numeric, power resolution (in kW) of the sessions' power}
}
\value{
tibble
}
\description{
Calculate connection and charging times according to energy, power and time resolution
}
\details{
All sessions' \code{Power} must be higher than \code{0}, to avoid \code{NaN} values from dividing
by zero.
The \code{ConnectionStartDateTime} is first aligned to the desired time resolution,
and the \code{ConnectionEndDateTime} is calculated according to the \code{ConnectionHours}.
The \code{ChargingHours} is recalculated with the values of \code{Energy} and \code{Power},
limited by \code{ConnectionHours}. Finally, the charging times are also calculated.
}
\examples{
suppressMessages(library(dplyr))

sessions <- head(evsim::california_ev_sessions, 10)

sessions \%>\%
  select(ConnectionStartDateTime, ConnectionEndDateTime, Power)

adapt_charging_features(
  sessions,
  time_resolution = 60,
  power_resolution = 0.01
) \%>\%
  select(ConnectionStartDateTime, ConnectionEndDateTime, Power)

adapt_charging_features(
  sessions,
  time_resolution = 15,
  power_resolution = 1
) \%>\%
  select(ConnectionStartDateTime, ConnectionEndDateTime, Power)


}
