% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R, R/InitWtErgmTerm.R
\name{nodecov-ergmTerm}
\alias{nodecov-ergmTerm}
\alias{InitErgmTerm.nodecov}
\alias{InitErgmTerm.nodemain}
\alias{nodemain-ergmTerm}
\alias{InitWtErgmTerm.nodecov}
\alias{InitWtErgmTerm.nodemain}
\title{Main effect of a covariate}
\usage{
# binary: nodecov(attr)

# binary: nodemain

# valued: nodecov(attr, form="sum")

# valued: nodemain(attr, form="sum")
}
\arguments{
\item{attr}{a vertex attribute specification (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details.)}

\item{form}{character how to aggregate tie values in a valued ERGM}
}
\description{
This term adds a single network statistic for each quantitative attribute or matrix column to the model equaling the sum of
\code{attr(i)} and \code{attr(j)} for all edges \eqn{(i,j)} in the
network. For categorical attributes, see \code{nodefactor} . Note that for
directed networks, \code{nodecov} equals \code{nodeicov} plus
\code{nodeocov} .
}
\note{
\pkg{ergm} versions 3.9.4 and earlier used different arguments for this
term. See \code{\link{ergm-options}} for how to invoke the old behaviour.
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "nodecov", "subsection")}
}
\concept{directed}
\concept{dyad-independent}
\concept{frequently-used}
\concept{quantitative nodal attribute}
\concept{undirected}
