% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm_estfun.R
\name{ergm.estfun}
\alias{ergm.estfun}
\alias{ergm.estfun.matrix}
\alias{ergm.estfun.mcmc}
\alias{ergm.estfun.mcmc.list}
\title{Compute the Sample Estimating Function Values of an ERGM.}
\usage{
ergm.estfun(stats, theta, model, ...)

\method{ergm.estfun}{matrix}(stats, theta, model, ...)

\method{ergm.estfun}{mcmc}(stats, theta, model, ...)

\method{ergm.estfun}{mcmc.list}(stats, theta, model, ...)
}
\arguments{
\item{stats}{An object representing sample statistics with observed values subtracted out.}

\item{theta}{Model parameter \eqn{q}-vector.}

\item{model}{An \code{\link{ergm_model}} object or its \code{etamap} element.}

\item{...}{Additional arguments for methods.}
}
\value{
An object of the same class as \code{stats} containing
\eqn{q}-vectors of estimating function values.
}
\description{
The estimating function for an ERGM is the score function: the
gradient of the log-likelihood, equalling \eqn{\eta'(\theta)^\top
\{g(y)-\mu(\theta)\}}, where \eqn{g(y)} is a \eqn{p}-vector of
observed network sufficient statistic, \eqn{\mu(\theta)} is the
expected value of the sufficient statistic under the model for
parameter value \eqn{\theta}, and \eqn{\eta'(\theta)} is the
\eqn{p} by \eqn{q} Jacobian matrix of the mapping from curved
parameters to natural parmeters.  If the model is linear, all
non-offset statistics are passed. If the model is curved, the score
estimating equations (3.1) by Hunter and Handcock (2006) are given
instead.
}
\section{Methods (by class)}{
\itemize{
\item \code{matrix}: Method for matrices with \eqn{p} columns.

\item \code{mcmc}: Method for \code{\link{mcmc}} objects with \eqn{p} variables.

\item \code{mcmc.list}: Method for  \code{\link{mcmc.list}} objects with \eqn{p} variables.
}}

\keyword{internal}
