% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm.Cprepare.R
\name{lasttoggle}
\alias{lasttoggle}
\alias{last.toggle}
\alias{last-toggle}
\alias{ergm.el.lasttoggle}
\alias{to.matrix.lasttoggle}
\alias{to.lasttoggle.matrix}
\title{Storing last toggle information in a network}
\usage{
ergm.el.lasttoggle(nw)

to.matrix.lasttoggle(nw)

to.lasttoggle.matrix(m, directed = TRUE, bipartite = FALSE)
}
\arguments{
\item{nw}{the network, otpionally with a \code{"lasttoggle"} network
attribute.}

\item{m}{a sociomatrix of appropriate dimension (rectangular for
bipartite networks).}

\item{directed, bipartite}{whether the matrix represents a directed
and/or a bipartite networks.}
}
\description{
An informal extension to \code{\link{network}} objects allowing
some limited temporal information to be stored.
WARNING: THIS DOCUMENTATION IS PROVIDED AS A COURTESY, AND THE API
DESCRIBED IS SUBJECT TO CHANGE WITHOUT NOTICE, DOWN TO COMPLETE
REMOVAL. NOT ALL FUNCTIONS THAT COULD SUPPORT IT DO. USE AT YOUR
OWN RISK.
}
\details{
While \code{\link[networkDynamic]{networkDynamic}} provides a flexible,
consistent method for storing dynamic networks, the \code{C} routines of
\code{\link[=ergm-package]{ergm}} and
\code{\link[tergm:tergm-package]{tergm}} required a simpler and more
lightweight representation.

This representation consisted of a single integer representing the
time stamp and an integer vector of length to
\code{\link{network.dyadcount}(nw)} --- the number of potential
ties in the network, giving the last time point during which each
of the dyads in the network had changed.

Though this is an API intended for internal use, some functions,
like \code{\link[tergm]{stergm}} (for EGMME),
\code{\link[tergm:simulate.stergm]{simulate}}, and
\code{\link[=summary.formula]{summary}} can be passed networks with
this information using the following \code{\link{network}} (i.e.,
\code{\link{\%n\%}}) attributes: \describe{ \item{list("time")}{the
time stamp associated with the network} \item{list("lasttoggle")}{a
vector of length \code{\link{network.dyadcount}(nw)}, giving the
last change time associated with each dyad. See the source code of
\code{\link[=ergm-package]{ergm}} internal functions
\code{to.matrix.lasttoggle}, \code{ergm.el.lasttoggle}, and
\code{to.lasttoggle.matrix} for how they are serialized.} }

For technical reasons, the \code{\link[tergm:tergm-package]{tergm}}
routines treat the \code{lasttoggle} time points as shifted by
\eqn{-1}.

Again, this API is subject to change without notice.
}
\section{Functions}{
\itemize{
\item \code{ergm.el.lasttoggle}: Returns a 3-column matrix whose first two
columns are tails and heads of extant edges and whose third
column are the creation times for those edges.

\item \code{to.matrix.lasttoggle}: Returns a numeric sociomatrix whose values
are last toggle times for the corresponding dyads.

\item \code{to.lasttoggle.matrix}: Serializes a matrix of last toggle times
into the form used by C code.
}}

\keyword{internal}
