% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmTerm.R
\name{degreeL-ergmTerm}
\alias{degreeL-ergmTerm}
\alias{InitErgmTerm.degreeL}
\title{Degree}
\usage{
# binary: degreeL(d, by=NULL, homophily=FALSE, levels=NULL, Ls=NULL)
}
\arguments{
\item{d}{a vector of distinct integers}

\item{by}{a character string giving the name of an attribute in the
network's vertex attribute list.}

\item{homophily}{If this is specified and \code{homophily} is \code{TRUE} ,
then degrees are calculated using the subnetwork consisting of only
edges whose endpoints have the same value of the \code{by} attribute.
If \code{by} is specified and
\code{homophily} is \code{FALSE} (the default), then separate degree
statistics are calculated for nodes having each separate
value of the attribute.}

\item{Ls}{a list (constructed by \code{\link[=list]{list()}} or \code{\link[=c]{c()}} of one or more Layer Logic specifications (c.f. Layer Logic section in the \code{\link[=Layer]{Layer()}} documentation). If specified, degree of a node \code{i} is considered to be the number of edges in all layers, combined.}
}
\description{
This term adds one
network statistic to the model for each element in \code{d} ; the \eqn{i} th
such statistic equals the number of nodes in the network of degree
\code{d[i]} , i.e. with exactly \code{d[i]} edges.

This term can only be used with undirected networks; for directed networks
see \code{idegree} and \code{odegree} .
}
\seealso{
\code{\link{ergmTerm}} for index of model terms currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmTerm", "degreeL", "subsection")}
}
\concept{categorical nodal attribute}
\concept{directed}
\concept{frequently-used}
\concept{undirected}
