% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny.R
\name{run_epoxy_example_app}
\alias{run_epoxy_example_app}
\title{Example epoxy Shiny apps}
\usage{
run_epoxy_example_app(
  name = c("ui_epoxy_html", "ui_epoxy_markdown", "ui_epoxy_mustache", "render_epoxy"),
  display.mode = "showcase",
  ...
)
}
\arguments{
\item{name}{Name of the example, currently one of \code{"ui_epoxy_html"},
\code{"ui_epoxy_markdown"}, \code{"ui_epoxy_mustache"}, or \code{"render_epoxy"}.}

\item{display.mode}{The mode in which to display the application. If set to
the value \code{"showcase"}, shows application code and metadata from a
\code{DESCRIPTION} file in the application directory alongside the
application. If set to \code{"normal"}, displays the application normally.
Defaults to \code{"auto"}, which displays the application in the mode given
in its \code{DESCRIPTION} file, if any.}

\item{...}{
  Arguments passed on to \code{\link[shiny:runApp]{shiny::runApp}}
  \describe{
    \item{\code{appDir}}{The application to run. Should be one of the following:
\itemize{
\item A directory containing \code{server.R}, plus, either \code{ui.R} or
a \code{www} directory that contains the file \code{index.html}.
\item A directory containing \code{app.R}.
\item An \code{.R} file containing a Shiny application, ending with an
expression that produces a Shiny app object.
\item A list with \code{ui} and \code{server} components.
\item A Shiny app object created by \code{\link[shiny:shinyApp]{shinyApp()}}.
}}
    \item{\code{port}}{The TCP port that the application should listen on. If the
\code{port} is not specified, and the \code{shiny.port} option is set (with
\code{options(shiny.port = XX)}), then that port will be used. Otherwise,
use a random port between 3000:8000, excluding ports that are blocked
by Google Chrome for being considered unsafe: 3659, 4045, 5060,
5061, 6000, 6566, 6665:6669 and 6697. Up to twenty random
ports will be tried.}
    \item{\code{launch.browser}}{If true, the system's default web browser will be
launched automatically after the app is started. Defaults to true in
interactive sessions only. The value of this parameter can also be a
function to call with the application's URL.}
    \item{\code{host}}{The IPv4 address that the application should listen on. Defaults
to the \code{shiny.host} option, if set, or \code{"127.0.0.1"} if not. See
Details.}
    \item{\code{workerId}}{Can generally be ignored. Exists to help some editions of
Shiny Server Pro route requests to the correct process.}
    \item{\code{quiet}}{Should Shiny status messages be shown? Defaults to FALSE.}
    \item{\code{test.mode}}{Should the application be launched in test mode? This is
only used for recording or running automated tests. Defaults to the
\code{shiny.testmode} option, or FALSE if the option is not set.}
  }}
}
\value{
Runs the Shiny example app interactively. Nothing is returned.
}
\description{
Run an example epoxy Shiny app showcasing the Shiny UI and server components
provided by epoxy.
}
\examples{
# List examples by passing `name = NULL`
run_epoxy_example_app(name = NULL)

}
\seealso{
\code{\link[=ui_epoxy_html]{ui_epoxy_html()}}, \code{\link[=ui_epoxy_markdown]{ui_epoxy_markdown()}}, \code{\link[=ui_epoxy_mustache]{ui_epoxy_mustache()}}, \code{\link[=render_epoxy]{render_epoxy()}}
}
