% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.R
\name{run_idf}
\alias{run_idf}
\alias{run_multi}
\title{Run simulations of EnergyPlus models.}
\usage{
run_idf(eplus, model, weather, output_dir = NULL, design_day = FALSE,
  annual = FALSE, expand_obj = TRUE, echo = FALSE)

run_multi(eplus, model, weather, output_dir = NULL, design_day = FALSE,
  annual = FALSE, parallel_backend = future::multiprocess)
}
\arguments{
\item{eplus}{An acceptable input of \code{\link[=use_eplus]{use_eplus()}} and \code{\link[=eplus_config]{eplus_config()}}.}

\item{model}{A path of an EnergyPlus IDF or IMF file.}

\item{weather}{A path of an EnergyPlus EPW weather file.}

\item{output_dir}{Output directory path. If NULL, which is default, the
directory of input model will be used.}

\item{design_day}{Force design-day-only simulation. Default: \code{FALSE}.}

\item{annual}{Force design-day-only simulation. Default: \code{FALSE}.}

\item{expand_obj}{Where to run ExpandObject preprocessor before simulation.
Default: \code{TRUE}.}

\item{echo}{Only applicable to \code{run_idf}. Show EnergyPlus simulation process
information to the console.  If \code{FALSE}, which is default, a
\link[processx:process]{processx::process} object will be return.}

\item{parallel_backend}{Acceptable input for \code{\link[future:plan]{future::plan()}}.}
}
\description{
\code{run_idf()} is a wrapper of EnergyPlus command line interface which enables to
run EnergyPlus model with different options.
}
\details{
\code{run_multi()} provides the functionality of running multiple models in
parallel.

Behind the scene, \code{run_multi()} uses the
\href{https://cran.r-project.org/package=furrr}{furrr} package which provides
mapping functions in parallel using
\href{https://cran.r-project.org/package=future}{future} package. It is suggested
to run simulations using \link[=job]{EplusJob} class, which provides much more
detailed controls on the simulation and also methods to extract simulation
output.
}
\examples{
\dontrun{

run_idf(8.8, "input.idf", "weather.epw")
}
}
\references{
\href{https://github.com/NREL/EnergyPlus/blob/develop/doc/running-energyplus-from-command-line.md}{Running EnergyPlus from Command Line (EnergyPlus GitHub Repository)}
}
