% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/episcan.R
\name{checkchunksize}
\alias{checkchunksize}
\title{Check chunk size}
\usage{
checkchunksize(c, m, n = NULL, ...)
}
\arguments{
\item{c}{an integer indicating the set chunk size.}

\item{m}{an integer indicating the number of variables(vaiants) in \code{geno1} if there is only one genotype input.}

\item{n}{an integer indicating the number of variables(vaiants) in \code{geno2} if there are two genotype inputs.
The default is NULL.}

\item{...}{not used.}
}
\value{
an integer indicating the chunk size
}
\description{
Check the chunk size whether it is over the given number of variables(vaiants) in genotype data. 
If yes, reset the chunk size equal to the number of variables(vaiants).
}
\examples{
set.seed(123)
geno1 <- matrix(sample(0:2, size = 1000, replace = TRUE, prob = c(0.5, 0.3, 0.2)), 
ncol = 10)
geno2 <- matrix(sample(0:2, size = 2000, replace = TRUE, prob = c(0.4, 0.3, 0.3)), 
ncol = 20)

# if chunk size is smaller, there is no problem
chunksize <- 10
checkchunksize(chunksize, ncol(geno1))

# if chunk size is bigger than the number of columns in genotype input, 
# set chunk size equal to the number of columns in genotype input
chuksize <- 12
checkchunksize(chunksize, ncol(geno1))

# if chunk size is bigger than the number of columns of geno1 and geno2, 
# set chunk size equal to the minima nunumber of columns of geno1 and geno2
chunksize <- 50
checkchunksize(chunksize, ncol(geno1), ncol(geno2))
}
