% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-bas_webservices.R
\name{runBASwebservice_pho2sylSegmental}
\alias{runBASwebservice_pho2sylSegmental}
\title{Creates a syllable segmentation on the basis of a phonetic segmentation.}
\usage{
runBASwebservice_pho2sylSegmental(handle, segmentAttributeDefinitionName,
  language, superLevel = NULL, sylAttributeDefinitionName = "MAS",
  params = list(wsync = "yes"), perspective = "default",
  patience = 0, resume = FALSE, verbose = TRUE)
}
\arguments{
\item{handle}{emuDB handle}

\item{segmentAttributeDefinitionName}{name of the attribute (not level!) containing a phonetic segmentation.}

\item{language}{language(s) to be used. If you pass a single string (e.g. "deu-DE"), this language will be used for all bundles.
Alternatively, you can select the language for every bundle individually. To do so, you must pass a data frame with the columns
session, bundle, language. This data frame must contain one row for every bundle in your emuDB.
Up-to-date lists of the languages accepted by all webservices can be found here:
\url{https://clarin.phonetik.uni-muenchen.de/BASWebServices/services/help}}

\item{superLevel}{name of the segments' parent level (typically the word level).
If set to NULL, the syllable level cannot be linked up.}

\item{sylAttributeDefinitionName}{attribute name for syllable segmentation}

\item{params}{named list of parameters to be passed on to the webservice. It is your own responsibility to
ensure that these parameters are compatible with the webservice API
(see \url{https://clarin.phonetik.uni-muenchen.de/BASWebServices/services/help}).
Some options accepted by the API (e.g. output format) cannot be set when calling a webservice from within emuR,
and will be overridden.}

\item{perspective}{the webApp perspective that the new level will be added to.
If NULL, the new level is not added to any perspectives.}

\item{patience}{If a web service call fails, it is repeated a further n times, with n being the value of patience.
Must be set to a value between 0 and 3.}

\item{resume}{If a previous call to this function has failed (and you think you have fixed the issue
that caused the error), you can set resume=TRUE to recover any progress made up to that point. This
will only work if your R temporary directory has not been deleted or emptied in the meantime.}

\item{verbose}{Display progress bars and other information}
}
\description{
This function calls the BAS webservice Pho2Syl to create a syllable segmentation on the basis
of a phonetic segmentation (created by, for example, \link{runBASwebservice_maus}).
You can provide the level of your word segmentation, or of any other hierarchically
dominant segmentation, via the superLevel parameter. This way, the new syllable
items can be linked up into the pre-existing hierarchy. If you do not provide
this input, the syllables will only be linked down to the segments.
}
\details{
All necessary level, link and parameter definitions are created in the process.
By default, Pho2Syl is run in word synchronized mode. To override this, call this function
with the parameter params=list(wsync="no").
}
\seealso{
Other BAS webservice functions: \code{\link{runBASwebservice_all}},
  \code{\link{runBASwebservice_chunker}},
  \code{\link{runBASwebservice_g2pForPronunciation}},
  \code{\link{runBASwebservice_g2pForTokenization}},
  \code{\link{runBASwebservice_maus}},
  \code{\link{runBASwebservice_minni}},
  \code{\link{runBASwebservice_pho2sylCanonical}}
}
\concept{BAS webservice functions}
